/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.notify;

import java.util.ArrayList;
import java.util.List;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.FileNotifyInformation;
import org.codelibs.jcifs.smb.internal.NotifyResponse;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.smb1.trans.nt.FileNotifyInformationImpl;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Response;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2ChangeNotifyResponse
extends ServerMessageBlock2Response
implements NotifyResponse {
    private final List<FileNotifyInformation> notifyInformation = new ArrayList<FileNotifyInformation>();

    public Smb2ChangeNotifyResponse(Configuration config) {
        super(config);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 9) {
            throw new SMBProtocolDecodingException("Expected structureSize = 9");
        }
        int bufferOffset = SMBUtil.readInt2(buffer, bufferIndex + 2) + this.getHeaderStart();
        int len = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        int elemStart = bufferOffset;
        FileNotifyInformationImpl i = new FileNotifyInformationImpl();
        bufferIndex += i.decode(buffer, bufferOffset, len);
        this.notifyInformation.add(i);
        while (i.getNextEntryOffset() > 0 && bufferIndex < bufferOffset + len) {
            elemStart = bufferIndex = elemStart + i.getNextEntryOffset();
            i = new FileNotifyInformationImpl();
            bufferIndex += i.decode(buffer, bufferIndex, len);
            this.notifyInformation.add(i);
        }
        return bufferIndex - start;
    }

    @Override
    public List<FileNotifyInformation> getNotifyInformation() {
        return this.notifyInformation;
    }

    @Override
    protected boolean isErrorResponseStatus() {
        return this.getStatus() != 268 && super.isErrorResponseStatus();
    }
}

