/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.nego;

import java.util.LinkedList;
import java.util.Set;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.DialectVersion;
import org.codelibs.jcifs.smb.internal.SmbNegotiationRequest;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Request;
import org.codelibs.jcifs.smb.internal.smb2.nego.EncryptionNegotiateContext;
import org.codelibs.jcifs.smb.internal.smb2.nego.NegotiateContextRequest;
import org.codelibs.jcifs.smb.internal.smb2.nego.NegotiateContextResponse;
import org.codelibs.jcifs.smb.internal.smb2.nego.PreauthIntegrityNegotiateContext;
import org.codelibs.jcifs.smb.internal.smb2.nego.Smb2NegotiateResponse;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2NegotiateRequest
extends ServerMessageBlock2Request<Smb2NegotiateResponse>
implements SmbNegotiationRequest {
    private final int[] dialects;
    private int capabilities;
    private final byte[] clientGuid = new byte[16];
    private final int securityMode;
    private final NegotiateContextRequest[] negotiateContexts;
    private byte[] preauthSalt;

    public Smb2NegotiateRequest(Configuration config, int securityMode) {
        super(config, 0);
        this.securityMode = securityMode;
        if (!config.isDfsDisabled()) {
            this.capabilities |= 1;
        }
        if (config.isEncryptionEnabled() && config.getMaximumVersion() != null && config.getMaximumVersion().atLeast(DialectVersion.SMB300)) {
            this.capabilities |= 0x40;
        }
        Set<DialectVersion> dvs = DialectVersion.range(DialectVersion.max(DialectVersion.SMB202, config.getMinimumVersion()), config.getMaximumVersion());
        this.dialects = new int[dvs.size()];
        int i = 0;
        for (DialectVersion ver : dvs) {
            this.dialects[i] = ver.getDialect();
            ++i;
        }
        if (config.getMaximumVersion().atLeast(DialectVersion.SMB210)) {
            System.arraycopy(config.getMachineId(), 0, this.clientGuid, 0, this.clientGuid.length);
        }
        LinkedList<NegotiateContextResponse> negoContexts = new LinkedList<NegotiateContextResponse>();
        if (config.getMaximumVersion() != null && config.getMaximumVersion().atLeast(DialectVersion.SMB311)) {
            byte[] salt = new byte[32];
            config.getRandom().nextBytes(salt);
            negoContexts.add(new PreauthIntegrityNegotiateContext(config, new int[]{1}, salt));
            this.preauthSalt = salt;
            if (config.isEncryptionEnabled()) {
                negoContexts.add(new EncryptionNegotiateContext(config, new int[]{2, 1}));
            }
        }
        this.negotiateContexts = negoContexts.toArray(new NegotiateContextRequest[negoContexts.size()]);
    }

    public int getSecurityMode() {
        return this.securityMode;
    }

    @Override
    public boolean isSigningEnforced() {
        return (this.getSecurityMode() & 2) != 0;
    }

    public int getCapabilities() {
        return this.capabilities;
    }

    public int[] getDialects() {
        return this.dialects;
    }

    public byte[] getClientGuid() {
        return this.clientGuid;
    }

    public NegotiateContextRequest[] getNegotiateContexts() {
        return this.negotiateContexts;
    }

    public byte[] getPreauthSalt() {
        return this.preauthSalt;
    }

    @Override
    protected Smb2NegotiateResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2NegotiateResponse> req) {
        return new Smb2NegotiateResponse(tc.getConfig());
    }

    @Override
    public int size() {
        int size = 100 + Smb2NegotiateRequest.size8(2 * this.dialects.length, 4);
        if (this.negotiateContexts != null) {
            for (NegotiateContextRequest ncr : this.negotiateContexts) {
                size += 8 + Smb2NegotiateRequest.size8(ncr.size());
            }
        }
        return Smb2NegotiateRequest.size8(size);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(36L, dst, dstIndex);
        SMBUtil.writeInt2(this.dialects.length, dst, dstIndex + 2);
        SMBUtil.writeInt2(this.securityMode, dst, dstIndex += 4);
        SMBUtil.writeInt2(0L, dst, dstIndex + 2);
        SMBUtil.writeInt4(this.capabilities, dst, dstIndex += 4);
        System.arraycopy(this.clientGuid, 0, dst, dstIndex += 4, 16);
        dstIndex += 16;
        int negotitateContextOffsetOffset = 0;
        if (this.negotiateContexts == null || this.negotiateContexts.length == 0) {
            SMBUtil.writeInt8(0L, dst, dstIndex);
        } else {
            negotitateContextOffsetOffset = dstIndex;
            SMBUtil.writeInt2(this.negotiateContexts.length, dst, dstIndex + 4);
            SMBUtil.writeInt2(0L, dst, dstIndex + 6);
        }
        dstIndex += 8;
        for (int dialect : this.dialects) {
            SMBUtil.writeInt2(dialect, dst, dstIndex);
            dstIndex += 2;
        }
        dstIndex += this.pad8(dstIndex);
        if (this.negotiateContexts != null && this.negotiateContexts.length != 0) {
            SMBUtil.writeInt4(dstIndex - this.getHeaderStart(), dst, negotitateContextOffsetOffset);
            for (NegotiateContextRequest nc : this.negotiateContexts) {
                SMBUtil.writeInt2(nc.getContextType(), dst, dstIndex);
                int lenOffset = dstIndex + 2;
                SMBUtil.writeInt4(0L, dst, dstIndex += 4);
                int dataLen = Smb2NegotiateRequest.size8(nc.encode(dst, dstIndex += 4));
                SMBUtil.writeInt2(dataLen, dst, lenOffset);
                dstIndex += dataLen;
            }
        }
        return dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

