/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.nego;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.smb2.nego.NegotiateContextRequest;
import org.codelibs.jcifs.smb.internal.smb2.nego.NegotiateContextResponse;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class EncryptionNegotiateContext
implements NegotiateContextRequest,
NegotiateContextResponse {
    public static final int NEGO_CTX_ENC_TYPE = 2;
    public static final int CIPHER_AES128_CCM = 1;
    public static final int CIPHER_AES128_GCM = 2;
    private int[] ciphers;

    public EncryptionNegotiateContext(Configuration config, int[] ciphers) {
        this.ciphers = ciphers;
    }

    public EncryptionNegotiateContext() {
    }

    public int[] getCiphers() {
        return this.ciphers;
    }

    @Override
    public int getContextType() {
        return 2;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(this.ciphers != null ? (long)this.ciphers.length : 0L, dst, dstIndex);
        dstIndex += 2;
        if (this.ciphers != null) {
            for (int cipher : this.ciphers) {
                SMBUtil.writeInt2(cipher, dst, dstIndex);
                dstIndex += 2;
            }
        }
        return dstIndex - start;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int nciphers = SMBUtil.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        this.ciphers = new int[nciphers];
        for (int i = 0; i < nciphers; ++i) {
            this.ciphers[i] = SMBUtil.readInt2(buffer, bufferIndex);
            bufferIndex += 2;
        }
        return bufferIndex - start;
    }

    @Override
    public int size() {
        return 4 + (this.ciphers != null ? 2 * this.ciphers.length : 0);
    }
}

