/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.ioctl;

import org.codelibs.jcifs.smb.Encodable;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class ValidateNegotiateInfoRequest
implements Encodable {
    private final int capabilities;
    private final byte[] clientGuid;
    private final int securityMode;
    private final int[] dialects;

    public ValidateNegotiateInfoRequest(int capabilities, byte[] clientGuid, int securityMode, int[] dialects) {
        this.capabilities = capabilities;
        this.clientGuid = clientGuid;
        this.securityMode = securityMode;
        this.dialects = dialects;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt4(this.capabilities, dst, dstIndex);
        System.arraycopy(this.clientGuid, 0, dst, dstIndex += 4, 16);
        SMBUtil.writeInt2(this.securityMode, dst, dstIndex += 16);
        SMBUtil.writeInt2(this.dialects.length, dst, dstIndex += 2);
        dstIndex += 2;
        for (int dialect : this.dialects) {
            SMBUtil.writeInt2(dialect, dst, dstIndex);
            dstIndex += 2;
        }
        return dstIndex - start;
    }

    @Override
    public int size() {
        return 24 + 2 * this.dialects.length;
    }
}

