/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.ioctl;

import org.codelibs.jcifs.smb.Encodable;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.SrvCopychunk;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class SrvCopychunkCopy
implements Encodable {
    private final byte[] sourceKey;
    private final SrvCopychunk[] chunks;

    public SrvCopychunkCopy(byte[] sourceKey, SrvCopychunk ... chunks) {
        this.sourceKey = sourceKey;
        this.chunks = chunks;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = dstIndex;
        System.arraycopy(this.sourceKey, 0, dst, dstIndex, 24);
        SMBUtil.writeInt4(this.chunks.length, dst, dstIndex += 24);
        dstIndex += 4;
        dstIndex += 4;
        for (SrvCopychunk chk : this.chunks) {
            dstIndex += chk.encode(dst, dstIndex);
        }
        return dstIndex - start;
    }

    @Override
    public int size() {
        return 32 + this.chunks.length * 24;
    }
}

