/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.io;

import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb2.RequestWithFileId;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Request;
import org.codelibs.jcifs.smb.internal.smb2.io.Smb2WriteResponse;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2WriteRequest
extends ServerMessageBlock2Request<Smb2WriteResponse>
implements RequestWithFileId {
    public static final int OVERHEAD = 112;
    private byte[] data;
    private int dataOffset;
    private int dataLength;
    private byte[] fileId;
    private long offset;
    private int channel;
    private int remainingBytes;
    private int writeFlags;

    public Smb2WriteRequest(Configuration config, byte[] fileId) {
        super(config, 9);
        this.fileId = fileId;
    }

    @Override
    public void setFileId(byte[] fileId) {
        this.fileId = fileId;
    }

    @Override
    protected Smb2WriteResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2WriteResponse> req) {
        return new Smb2WriteResponse(tc.getConfig());
    }

    public void setData(byte[] data, int offset, int length) {
        this.data = data;
        this.dataOffset = offset;
        this.dataLength = length;
    }

    public void setRemainingBytes(int remainingBytes) {
        this.remainingBytes = remainingBytes;
    }

    public void setWriteFlags(int writeFlags) {
        this.writeFlags = writeFlags;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public int size() {
        return Smb2WriteRequest.size8(112 + this.dataLength);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(49L, dst, dstIndex);
        int dataOffsetOffset = dstIndex + 2;
        SMBUtil.writeInt4(this.dataLength, dst, dstIndex += 4);
        SMBUtil.writeInt8(this.offset, dst, dstIndex += 4);
        System.arraycopy(this.fileId, 0, dst, dstIndex += 8, 16);
        SMBUtil.writeInt4(this.channel, dst, dstIndex += 16);
        SMBUtil.writeInt4(this.remainingBytes, dst, dstIndex += 4);
        SMBUtil.writeInt2(0L, dst, dstIndex += 4);
        SMBUtil.writeInt2(0L, dst, dstIndex + 2);
        SMBUtil.writeInt4(this.writeFlags, dst, dstIndex += 4);
        SMBUtil.writeInt2((dstIndex += 4) - this.getHeaderStart(), dst, dataOffsetOffset);
        if (dstIndex + this.dataLength > dst.length) {
            throw new IllegalArgumentException(String.format("Data exceeds buffer size ( remain buffer: %d data length: %d)", dst.length - dstIndex, this.dataLength));
        }
        System.arraycopy(this.data, this.dataOffset, dst, dstIndex, this.dataLength);
        return (dstIndex += this.dataLength) - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

