/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.io;

import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb2.RequestWithFileId;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Request;
import org.codelibs.jcifs.smb.internal.smb2.io.Smb2ReadResponse;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2ReadRequest
extends ServerMessageBlock2Request<Smb2ReadResponse>
implements RequestWithFileId {
    public static byte SMB2_READFLAG_READ_UNBUFFERED = 1;
    public static int SMB2_CHANNEL_NONE = 0;
    public static int SMB2_CHANNEL_RDMA_V1 = 1;
    public static int SMB2_CHANNEL_RDMA_V1_INVALIDATE = 2;
    private byte[] fileId;
    private final byte[] outputBuffer;
    private final int outputBufferOffset;
    private byte padding;
    private byte readFlags;
    private int readLength;
    private long offset;
    private int minimumCount;
    private int channel;
    private int remainingBytes;

    public Smb2ReadRequest(Configuration config, byte[] fileId, byte[] outputBuffer, int outputBufferOffset) {
        super(config, 8);
        this.fileId = fileId;
        this.outputBuffer = outputBuffer;
        this.outputBufferOffset = outputBufferOffset;
    }

    @Override
    protected Smb2ReadResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2ReadResponse> req) {
        return new Smb2ReadResponse(tc.getConfig(), this.outputBuffer, this.outputBufferOffset);
    }

    @Override
    public void setFileId(byte[] fileId) {
        this.fileId = fileId;
    }

    public void setPadding(byte padding) {
        this.padding = padding;
    }

    public void setReadFlags(byte readFlags) {
        this.readFlags = readFlags;
    }

    public void setReadLength(int readLength) {
        this.readLength = readLength;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setMinimumCount(int minimumCount) {
        this.minimumCount = minimumCount;
    }

    public void setRemainingBytes(int remainingBytes) {
        this.remainingBytes = remainingBytes;
    }

    @Override
    public int size() {
        return Smb2ReadRequest.size8(113);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(49L, dst, dstIndex);
        dst[dstIndex + 2] = this.padding;
        dst[dstIndex + 3] = this.readFlags;
        SMBUtil.writeInt4(this.readLength, dst, dstIndex += 4);
        SMBUtil.writeInt8(this.offset, dst, dstIndex += 4);
        System.arraycopy(this.fileId, 0, dst, dstIndex += 8, 16);
        SMBUtil.writeInt4(this.minimumCount, dst, dstIndex += 16);
        SMBUtil.writeInt4(this.channel, dst, dstIndex += 4);
        SMBUtil.writeInt4(this.remainingBytes, dst, dstIndex += 4);
        SMBUtil.writeInt2(0L, dst, dstIndex += 4);
        SMBUtil.writeInt2(0L, dst, dstIndex + 2);
        dst[dstIndex += 4] = 0;
        return ++dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

