/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.info;

import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.Encodable;
import org.codelibs.jcifs.smb.internal.fscc.FileInformation;
import org.codelibs.jcifs.smb.internal.smb2.RequestWithFileId;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Request;
import org.codelibs.jcifs.smb.internal.smb2.Smb2Constants;
import org.codelibs.jcifs.smb.internal.smb2.info.Smb2SetInfoResponse;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2SetInfoRequest
extends ServerMessageBlock2Request<Smb2SetInfoResponse>
implements RequestWithFileId {
    private byte[] fileId;
    private byte infoType;
    private byte fileInfoClass;
    private int additionalInformation;
    private Encodable info;

    public Smb2SetInfoRequest(Configuration config) {
        this(config, Smb2Constants.UNSPECIFIED_FILEID);
    }

    public Smb2SetInfoRequest(Configuration config, byte[] fileId) {
        super(config, 17);
        this.fileId = fileId;
    }

    @Override
    public void setFileId(byte[] fileId) {
        this.fileId = fileId;
    }

    public void setInfoType(byte infoType) {
        this.infoType = infoType;
    }

    public void setFileInfoClass(byte fileInfoClass) {
        this.fileInfoClass = fileInfoClass;
    }

    public void setAdditionalInformation(int additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public <T extends FileInformation & Encodable> void setFileInformation(T fi) {
        this.setInfoType((byte)1);
        this.setFileInfoClass(fi.getFileInformationLevel());
        this.setInfo(fi);
    }

    public void setInfo(Encodable info) {
        this.info = info;
    }

    @Override
    protected Smb2SetInfoResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2SetInfoResponse> req) {
        return new Smb2SetInfoResponse(tc.getConfig());
    }

    @Override
    public int size() {
        return Smb2SetInfoRequest.size8(96 + this.info.size());
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(33L, dst, dstIndex);
        dst[dstIndex + 2] = this.infoType;
        dst[dstIndex + 3] = this.fileInfoClass;
        int bufferLengthOffset = dstIndex += 4;
        int bufferOffsetOffset = dstIndex += 4;
        SMBUtil.writeInt4(this.additionalInformation, dst, dstIndex += 4);
        System.arraycopy(this.fileId, 0, dst, dstIndex += 4, 16);
        SMBUtil.writeInt2((dstIndex += 16) - this.getHeaderStart(), dst, bufferOffsetOffset);
        int len = this.info.encode(dst, dstIndex);
        SMBUtil.writeInt4(len, dst, bufferLengthOffset);
        return (dstIndex += len) - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

