/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2.info;

import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.Encodable;
import org.codelibs.jcifs.smb.internal.smb2.RequestWithFileId;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Request;
import org.codelibs.jcifs.smb.internal.smb2.Smb2Constants;
import org.codelibs.jcifs.smb.internal.smb2.info.Smb2QueryInfoResponse;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class Smb2QueryInfoRequest
extends ServerMessageBlock2Request<Smb2QueryInfoResponse>
implements RequestWithFileId {
    private byte infoType;
    private byte fileInfoClass;
    private final int outputBufferLength;
    private int additionalInformation;
    private int queryFlags;
    private byte[] fileId;
    private Encodable inputBuffer;

    public Smb2QueryInfoRequest(Configuration config) {
        this(config, Smb2Constants.UNSPECIFIED_FILEID);
    }

    public Smb2QueryInfoRequest(Configuration config, byte[] fileId) {
        super(config, 16);
        this.outputBufferLength = Math.min(config.getMaximumBufferSize(), config.getListSize()) - 72 & 0xFFFFFFF8;
        this.fileId = fileId;
    }

    @Override
    public void setFileId(byte[] fileId) {
        this.fileId = fileId;
    }

    public final void setInfoType(byte infoType) {
        this.infoType = infoType;
    }

    public final void setFileInfoClass(byte fileInfoClass) {
        this.setInfoType((byte)1);
        this.fileInfoClass = fileInfoClass;
    }

    public final void setFilesystemInfoClass(byte fileInfoClass) {
        this.setInfoType((byte)2);
        this.fileInfoClass = fileInfoClass;
    }

    public final void setAdditionalInformation(int additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public final void setQueryFlags(int queryFlags) {
        this.queryFlags = queryFlags;
    }

    @Override
    protected Smb2QueryInfoResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2QueryInfoResponse> req) {
        return new Smb2QueryInfoResponse(tc.getConfig(), this.infoType, this.fileInfoClass);
    }

    @Override
    public int size() {
        int size = 104;
        if (this.inputBuffer != null) {
            size += this.inputBuffer.size();
        }
        return Smb2QueryInfoRequest.size8(size);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(41L, dst, dstIndex);
        dst[dstIndex + 2] = this.infoType;
        dst[dstIndex + 3] = this.fileInfoClass;
        SMBUtil.writeInt4(this.outputBufferLength, dst, dstIndex += 4);
        int inBufferOffsetOffset = dstIndex += 4;
        int inBufferLengthOffset = dstIndex += 4;
        SMBUtil.writeInt4(this.additionalInformation, dst, dstIndex += 4);
        SMBUtil.writeInt4(this.queryFlags, dst, dstIndex += 4);
        System.arraycopy(this.fileId, 0, dst, dstIndex += 4, 16);
        dstIndex += 16;
        if (this.inputBuffer == null) {
            SMBUtil.writeInt2(0L, dst, inBufferOffsetOffset);
            SMBUtil.writeInt4(0L, dst, inBufferLengthOffset);
        } else {
            SMBUtil.writeInt2(dstIndex - this.getHeaderStart(), dst, inBufferOffsetOffset);
            int len = this.inputBuffer.encode(dst, dstIndex);
            SMBUtil.writeInt4(len, dst, inBufferLengthOffset);
            dstIndex += len;
        }
        return dstIndex - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

