/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlock;
import org.codelibs.jcifs.smb.internal.SMBSigningDigest;
import org.codelibs.jcifs.smb.internal.smb2.Smb3KeyDerivation;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Crypto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Smb2SigningDigest
implements SMBSigningDigest {
    private static final Logger log = LoggerFactory.getLogger(Smb2SigningDigest.class);
    private static final int SIGNATURE_OFFSET = 48;
    private static final int SIGNATURE_LENGTH = 16;
    private final Mac digest;

    public Smb2SigningDigest(byte[] sessionKey, int dialect, byte[] preauthIntegrityHash) throws GeneralSecurityException {
        byte[] signingKey;
        Mac m;
        switch (dialect) {
            case 514: 
            case 528: {
                m = Mac.getInstance("HmacSHA256");
                signingKey = sessionKey;
                break;
            }
            case 768: 
            case 770: {
                signingKey = Smb3KeyDerivation.deriveSigningKey(dialect, sessionKey, new byte[0]);
                m = Mac.getInstance("AESCMAC", Crypto.getProvider());
                break;
            }
            case 785: {
                if (preauthIntegrityHash == null) {
                    throw new IllegalArgumentException("Missing preauthIntegrityHash for SMB 3.1");
                }
                signingKey = Smb3KeyDerivation.deriveSigningKey(dialect, sessionKey, preauthIntegrityHash);
                m = Mac.getInstance("AESCMAC", Crypto.getProvider());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown dialect");
            }
        }
        m.init(new SecretKeySpec(signingKey, "HMAC"));
        this.digest = m;
    }

    @Override
    public synchronized void sign(byte[] data, int offset, int length, CommonServerMessageBlock request, CommonServerMessageBlock response) {
        this.digest.reset();
        int index = offset + 48;
        for (int i = 0; i < 16; ++i) {
            data[index + i] = 0;
        }
        int oldFlags = SMBUtil.readInt4(data, offset + 16);
        int flags = oldFlags | 8;
        SMBUtil.writeInt4(flags, data, offset + 16);
        this.digest.update(data, offset, length);
        byte[] sig = this.digest.doFinal();
        System.arraycopy(sig, 0, data, offset + 48, 16);
    }

    @Override
    public synchronized boolean verify(byte[] data, int offset, int length, int extraPad, CommonServerMessageBlock msg) {
        this.digest.reset();
        int flags = SMBUtil.readInt4(data, offset + 16);
        if ((flags & 8) == 0) {
            log.error("The server did not sign a message we expected to be signed");
            return true;
        }
        byte[] sig = new byte[16];
        System.arraycopy(data, offset + 48, sig, 0, 16);
        int index = offset + 48;
        for (int i = 0; i < 16; ++i) {
            data[index + i] = 0;
        }
        this.digest.update(data, offset, length);
        byte[] cmp = new byte[16];
        System.arraycopy(this.digest.doFinal(), 0, cmp, 0, 16);
        return !MessageDigest.isEqual(sig, cmp);
    }
}

