/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockResponse;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2;
import org.codelibs.jcifs.smb.internal.smb2.Smb2SigningDigest;

public abstract class ServerMessageBlock2Response
extends ServerMessageBlock2
implements CommonServerMessageBlockResponse {
    private boolean received;
    private boolean error;
    private Long expiration;
    private boolean verifyFailed;
    private Exception exception;
    private boolean asyncHandled;

    public ServerMessageBlock2Response(Configuration config, int command) {
        super(config, command);
    }

    public ServerMessageBlock2Response(Configuration config) {
        super(config);
    }

    @Override
    public CommonServerMessageBlockResponse getNextResponse() {
        return (CommonServerMessageBlockResponse)((Object)this.getNext());
    }

    @Override
    public void prepare(CommonServerMessageBlockRequest next) {
        CommonServerMessageBlockResponse n = this.getNextResponse();
        if (n != null) {
            n.prepare(next);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.received = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void received() {
        if (this.isAsync() && this.getStatus() == 259) {
            ServerMessageBlock2Response serverMessageBlock2Response = this;
            synchronized (serverMessageBlock2Response) {
                this.notifyAll();
            }
            return;
        }
        this.received = true;
        ServerMessageBlock2Response serverMessageBlock2Response = this;
        synchronized (serverMessageBlock2Response) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void exception(Exception e) {
        this.error = true;
        this.exception = e;
        this.received = true;
        ServerMessageBlock2Response serverMessageBlock2Response = this;
        synchronized (serverMessageBlock2Response) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void error() {
        this.error = true;
        ServerMessageBlock2Response serverMessageBlock2Response = this;
        synchronized (serverMessageBlock2Response) {
            this.notifyAll();
        }
    }

    @Override
    public final void clearReceived() {
        this.received = false;
    }

    @Override
    public final boolean isReceived() {
        return this.received;
    }

    @Override
    public final boolean isError() {
        return this.error;
    }

    public boolean isSigned() {
        return (this.getFlags() & 8) != 0;
    }

    @Override
    public Long getExpiration() {
        return this.expiration;
    }

    @Override
    public void setExpiration(Long exp) {
        this.expiration = exp;
    }

    public boolean isAsyncHandled() {
        return this.asyncHandled;
    }

    public void setAsyncHandled(boolean asyncHandled) {
        this.asyncHandled = asyncHandled;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public final int getErrorCode() {
        return this.getStatus();
    }

    @Override
    public final boolean isVerifyFailed() {
        return this.verifyFailed;
    }

    @Override
    public int getGrantedCredits() {
        return this.getCredit();
    }

    @Override
    protected void haveResponse(byte[] buffer, int start, int len) throws SMBProtocolDecodingException {
        if (this.isRetainPayload()) {
            byte[] payload = new byte[len];
            System.arraycopy(buffer, start, payload, 0, len);
            this.setRawPayload(payload);
        }
        if (!this.verifySignature(buffer, start, len)) {
            throw new SMBProtocolDecodingException("Signature verification failed for " + this.getClass().getName());
        }
        this.setAsyncHandled(false);
        this.received();
    }

    @Override
    public boolean verifySignature(byte[] buffer, int i, int size) {
        Smb2SigningDigest dgst = this.getDigest();
        if (dgst != null && !this.isAsync() && (this.getConfig().isRequireSecureNegotiate() || this.getErrorCode() == 0)) {
            boolean verify;
            this.verifyFailed = verify = dgst.verify(buffer, i, size, 0, this);
            return !verify;
        }
        return true;
    }
}

