/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb2;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.impl.SmbException;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlock;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockResponse;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.SMBSigningDigest;
import org.codelibs.jcifs.smb.internal.smb2.ServerMessageBlock2Response;
import org.codelibs.jcifs.smb.internal.smb2.Smb2SigningDigest;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;

public abstract class ServerMessageBlock2
implements CommonServerMessageBlock {
    protected static final short SMB2_NEGOTIATE = 0;
    protected static final short SMB2_SESSION_SETUP = 1;
    protected static final short SMB2_LOGOFF = 2;
    protected static final short SMB2_TREE_CONNECT = 3;
    protected static final short SMB2_TREE_DISCONNECT = 4;
    protected static final short SMB2_CREATE = 5;
    protected static final short SMB2_CLOSE = 6;
    protected static final short SMB2_FLUSH = 7;
    protected static final short SMB2_READ = 8;
    protected static final short SMB2_WRITE = 9;
    protected static final short SMB2_LOCK = 10;
    protected static final short SMB2_IOCTL = 11;
    protected static final short SMB2_CANCEL = 12;
    protected static final short SMB2_ECHO = 13;
    protected static final short SMB2_QUERY_DIRECTORY = 14;
    protected static final short SMB2_CHANGE_NOTIFY = 15;
    protected static final short SMB2_QUERY_INFO = 16;
    protected static final short SMB2_SET_INFO = 17;
    protected static final short SMB2_OPLOCK_BREAK = 18;
    public static final int SMB2_FLAGS_SERVER_TO_REDIR = 1;
    public static final int SMB2_FLAGS_ASYNC_COMMAND = 2;
    public static final int SMB2_FLAGS_RELATED_OPERATIONS = 4;
    public static final int SMB2_FLAGS_SIGNED = 8;
    public static final int SMB2_FLAGS_PRIORITY_MASK = 112;
    public static final int SMB2_FLAGS_DFS_OPERATIONS = 0x10000000;
    public static final int SMB2_FLAGS_REPLAY_OPERATION = 0x20000000;
    private int command;
    private int flags;
    private int length;
    private int headerStart;
    private int wordCount;
    private int byteCount;
    private final byte[] signature = new byte[16];
    private Smb2SigningDigest digest = null;
    private final Configuration config;
    private int creditCharge;
    private int status;
    private int credit;
    private int nextCommand;
    private int readSize;
    private boolean async;
    private int treeId;
    private long mid;
    private long asyncId;
    private long sessionId;
    private byte errorContextCount;
    private byte[] errorData;
    private boolean retainPayload;
    private byte[] rawPayload;
    private ServerMessageBlock2 next;

    protected ServerMessageBlock2(Configuration config) {
        this.config = config;
    }

    protected ServerMessageBlock2(Configuration config, int command) {
        this.config = config;
        this.command = command;
    }

    protected Configuration getConfig() {
        return this.config;
    }

    @Override
    public void reset() {
        this.flags = 0;
        this.digest = null;
        this.sessionId = 0L;
        this.treeId = 0;
    }

    @Override
    public final int getCommand() {
        return this.command;
    }

    public final int getNextCommandOffset() {
        return this.nextCommand;
    }

    public void setReadSize(int readSize) {
        this.readSize = readSize;
    }

    public boolean isAsync() {
        return this.async;
    }

    @Override
    public final void setCommand(int command) {
        this.command = command;
    }

    public final int getTreeId() {
        return this.treeId;
    }

    public final void setTreeId(int treeId) {
        this.treeId = treeId;
        if (this.next != null) {
            this.next.setTreeId(treeId);
        }
    }

    public final long getAsyncId() {
        return this.asyncId;
    }

    public final void setAsyncId(long asyncId) {
        this.asyncId = asyncId;
    }

    public final int getCredit() {
        return this.credit;
    }

    public final void setCredit(int credit) {
        this.credit = credit;
    }

    public final int getCreditCharge() {
        return this.creditCharge;
    }

    @Override
    public void retainPayload() {
        this.retainPayload = true;
    }

    @Override
    public boolean isRetainPayload() {
        return this.retainPayload;
    }

    @Override
    public byte[] getRawPayload() {
        return this.rawPayload;
    }

    @Override
    public void setRawPayload(byte[] rawPayload) {
        this.rawPayload = rawPayload;
    }

    @Override
    public Smb2SigningDigest getDigest() {
        return this.digest;
    }

    @Override
    public void setDigest(SMBSigningDigest digest) {
        this.digest = (Smb2SigningDigest)digest;
        if (this.next != null) {
            this.next.setDigest(digest);
        }
    }

    public final int getStatus() {
        return this.status;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public final void setSessionId(long sessionId) {
        this.sessionId = sessionId;
        if (this.next != null) {
            this.next.setSessionId(sessionId);
        }
    }

    @Override
    public void setExtendedSecurity(boolean extendedSecurity) {
    }

    @Override
    public void setUid(int uid) {
    }

    public final int getFlags() {
        return this.flags;
    }

    public final void addFlags(int flag) {
        this.flags |= flag;
    }

    public final void clearFlags(int flag) {
        this.flags &= ~flag;
    }

    @Override
    public final long getMid() {
        return this.mid;
    }

    @Override
    public final void setMid(long mid) {
        this.mid = mid;
    }

    public boolean chain(ServerMessageBlock2 n) {
        if (this.next != null) {
            return this.next.chain(n);
        }
        n.addFlags(4);
        this.next = n;
        return true;
    }

    protected ServerMessageBlock2 getNext() {
        return this.next;
    }

    protected void setNext(ServerMessageBlock2 n) {
        this.next = n;
    }

    @Override
    public ServerMessageBlock2Response getResponse() {
        return null;
    }

    @Override
    public void setResponse(CommonServerMessageBlockResponse msg) {
    }

    public final byte[] getErrorData() {
        return this.errorData;
    }

    public final byte getErrorContextCount() {
        return this.errorContextCount;
    }

    public final int getHeaderStart() {
        return this.headerStart;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        int start = this.headerStart = dstIndex;
        dstIndex += this.writeHeaderWireFormat(dst, dstIndex);
        this.byteCount = this.writeBytesWireFormat(dst, dstIndex);
        dstIndex += this.byteCount;
        dstIndex += this.pad8(dstIndex);
        int len = this.length = dstIndex - start;
        if (this.next != null) {
            int nextStart = dstIndex;
            dstIndex += this.next.encode(dst, dstIndex);
            int off = nextStart - start;
            SMBUtil.writeInt4(off, dst, start + 20);
            len += dstIndex - nextStart;
        }
        if (this.digest != null) {
            this.digest.sign(dst, this.headerStart, this.length, this, this.getResponse());
        }
        if (this.isRetainPayload()) {
            this.rawPayload = new byte[len];
            System.arraycopy(dst, start, this.rawPayload, 0, len);
        }
        return len;
    }

    protected static final int size8(int size) {
        return ServerMessageBlock2.size8(size, 0);
    }

    protected static final int size8(int size, int align) {
        int rem = size % 8 - align;
        if (rem == 0) {
            return size;
        }
        if (rem < 0) {
            rem = 8 + rem;
        }
        return size + 8 - rem;
    }

    protected final int pad8(int dstIndex) {
        int fromHdr = dstIndex - this.headerStart;
        int rem = fromHdr % 8;
        if (rem == 0) {
            return 0;
        }
        return 8 - rem;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        return this.decode(buffer, bufferIndex, false);
    }

    public int decode(byte[] buffer, int bufferIndex, boolean compound) throws SMBProtocolDecodingException {
        int start = this.headerStart = bufferIndex;
        bufferIndex += this.readHeaderWireFormat(buffer, bufferIndex);
        bufferIndex = this.isErrorResponseStatus() ? (bufferIndex += this.readErrorResponse(buffer, bufferIndex)) : (bufferIndex += this.readBytesWireFormat(buffer, bufferIndex));
        int len = this.length = bufferIndex - start;
        if (this.nextCommand != 0) {
            len += this.pad8(bufferIndex);
        } else if (compound && this.nextCommand == 0 && this.readSize > 0) {
            int rem = this.readSize - this.length;
            len += rem;
        }
        this.haveResponse(buffer, start, len);
        if (this.nextCommand != 0 && this.next != null && this.nextCommand % 8 != 0) {
            throw new SMBProtocolDecodingException("Chained command is not aligned");
        }
        return len;
    }

    protected boolean isErrorResponseStatus() {
        return this.getStatus() != 0;
    }

    protected void haveResponse(byte[] buffer, int start, int len) throws SMBProtocolDecodingException {
    }

    protected int readErrorResponse(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 9) {
            throw new SMBProtocolDecodingException("Error structureSize should be 9");
        }
        this.errorContextCount = buffer[bufferIndex + 2];
        int bc = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        if (bc > 0) {
            this.errorData = new byte[bc];
            System.arraycopy(buffer, bufferIndex, this.errorData, 0, bc);
            bufferIndex += bc;
        }
        return bufferIndex - start;
    }

    protected int writeHeaderWireFormat(byte[] dst, int dstIndex) {
        System.arraycopy(SMBUtil.SMB2_HEADER, 0, dst, dstIndex, SMBUtil.SMB2_HEADER.length);
        SMBUtil.writeInt2(this.creditCharge, dst, dstIndex + 6);
        SMBUtil.writeInt2(this.command, dst, dstIndex + 12);
        SMBUtil.writeInt2(this.credit, dst, dstIndex + 14);
        SMBUtil.writeInt4(this.flags, dst, dstIndex + 16);
        SMBUtil.writeInt4(this.nextCommand, dst, dstIndex + 20);
        SMBUtil.writeInt8(this.mid, dst, dstIndex + 24);
        if (this.async) {
            SMBUtil.writeInt8(this.asyncId, dst, dstIndex + 32);
        } else {
            SMBUtil.writeInt4(this.treeId, dst, dstIndex + 36);
        }
        SMBUtil.writeInt8(this.sessionId, dst, dstIndex + 40);
        return 64;
    }

    protected int readHeaderWireFormat(byte[] buffer, int bufferIndex) {
        SMBUtil.readInt4(buffer, bufferIndex);
        SMBUtil.readInt2(buffer, bufferIndex += 4);
        this.creditCharge = SMBUtil.readInt2(buffer, bufferIndex + 2);
        this.status = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.command = SMBUtil.readInt2(buffer, bufferIndex += 4);
        this.credit = SMBUtil.readInt2(buffer, bufferIndex + 2);
        this.flags = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.nextCommand = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.mid = SMBUtil.readInt8(buffer, bufferIndex += 4);
        bufferIndex += 8;
        if ((this.flags & 2) == 2) {
            this.async = true;
            this.asyncId = SMBUtil.readInt8(buffer, bufferIndex);
            bufferIndex += 8;
        } else {
            this.async = false;
            this.treeId = SMBUtil.readInt4(buffer, bufferIndex += 4);
            bufferIndex += 4;
        }
        this.sessionId = SMBUtil.readInt8(buffer, bufferIndex);
        System.arraycopy(buffer, bufferIndex += 8, this.signature, 0, 16);
        bufferIndex += 16;
        return 64;
    }

    boolean isResponse() {
        return (this.flags & 1) == 1;
    }

    protected abstract int writeBytesWireFormat(byte[] var1, int var2);

    protected abstract int readBytesWireFormat(byte[] var1, int var2) throws SMBProtocolDecodingException;

    public int hashCode() {
        return (int)this.mid;
    }

    public boolean equals(Object obj) {
        return obj instanceof ServerMessageBlock2 && ((ServerMessageBlock2)obj).mid == this.mid;
    }

    public String toString() {
        String c = switch (this.command) {
            case 0 -> "SMB2_NEGOTIATE";
            case 1 -> "SMB2_SESSION_SETUP";
            case 2 -> "SMB2_LOGOFF";
            case 3 -> "SMB2_TREE_CONNECT";
            case 4 -> "SMB2_TREE_DISCONNECT";
            case 5 -> "SMB2_CREATE";
            case 6 -> "SMB2_CLOSE";
            case 7 -> "SMB2_FLUSH";
            case 8 -> "SMB2_READ";
            case 9 -> "SMB2_WRITE";
            case 10 -> "SMB2_LOCK";
            case 11 -> "SMB2_IOCTL";
            case 12 -> "SMB2_CANCEL";
            case 13 -> "SMB2_ECHO";
            case 14 -> "SMB2_QUERY_DIRECTORY";
            case 15 -> "SMB2_CHANGE_NOTIFY";
            case 16 -> "SMB2_QUERY_INFO";
            case 17 -> "SMB2_SET_INFO";
            case 18 -> "SMB2_OPLOCK_BREAK";
            default -> "UNKNOWN";
        };
        String str = this.status == 0 ? "0" : SmbException.getMessageByCode(this.status);
        return "command=" + c + ",status=" + str + ",flags=0x" + Hexdump.toHexString(this.flags, 4) + ",mid=" + this.mid + ",wordCount=" + this.wordCount + ",byteCount=" + this.byteCount;
    }
}

