/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.trans2;

import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.trans.SmbComTransaction;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;
import org.codelibs.jcifs.smb.util.Hexdump;

public class Trans2QueryFSInformation
extends SmbComTransaction {
    private final int informationLevel;

    public Trans2QueryFSInformation(Configuration config, int informationLevel) {
        super(config, (byte)50, (byte)3);
        this.informationLevel = informationLevel;
        this.totalParameterCount = 2;
        this.totalDataCount = 0;
        this.maxParameterCount = 0;
        this.maxDataCount = 800;
        this.maxSetupCount = 0;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex] = this.getSubCommand();
        int n = ++dstIndex;
        ++dstIndex;
        dst[n] = 0;
        return 2;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(Trans2QueryFSInformation.mapInformationLevel(this.informationLevel), dst, dstIndex);
        return (dstIndex += 2) - start;
    }

    private static int mapInformationLevel(int il) {
        switch (il) {
            case -1: {
                return 1;
            }
            case 3: {
                return 259;
            }
        }
        throw new IllegalArgumentException("Unhandled information level");
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return "Trans2QueryFSInformation[" + super.toString() + ",informationLevel=0x" + Hexdump.toHexString(this.informationLevel, 3) + "]";
    }
}

