/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.net;

import java.io.UnsupportedEncodingException;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.smb1.trans.SmbComTransaction;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class NetServerEnum2
extends SmbComTransaction {
    public static final int SV_TYPE_ALL = -1;
    public static final int SV_TYPE_DOMAIN_ENUM = Integer.MIN_VALUE;
    static final String[] DESCR = new String[]{"WrLehDO\u0000B16BBDz\u0000", "WrLehDz\u0000B16BBDz\u0000"};
    String domain;
    String lastName = null;
    int serverTypes;

    public NetServerEnum2(Configuration config, String domain, int serverTypes) {
        super(config, (byte)37, (byte)104);
        this.domain = domain;
        this.serverTypes = serverTypes;
        this.name = "\\PIPE\\LANMAN";
        this.maxParameterCount = 8;
        this.maxDataCount = 16384;
        this.maxSetupCount = 0;
        this.setupCount = 0;
        this.timeout = 5000;
    }

    @Override
    public void reset(int key, String lastN) {
        super.reset();
        this.lastName = lastN;
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        byte[] descr;
        int start = dstIndex;
        int which = this.getSubCommand() == 104 ? 0 : 1;
        try {
            descr = DESCR[which].getBytes("ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            return 0;
        }
        SMBUtil.writeInt2(this.getSubCommand() & 0xFF, dst, dstIndex);
        System.arraycopy(descr, 0, dst, dstIndex += 2, descr.length);
        SMBUtil.writeInt2(1L, dst, dstIndex += descr.length);
        SMBUtil.writeInt2(this.maxDataCount, dst, dstIndex += 2);
        SMBUtil.writeInt4(this.serverTypes, dst, dstIndex += 2);
        dstIndex += 4;
        dstIndex += this.writeString(this.domain.toUpperCase(), dst, dstIndex, false);
        if (which == 1) {
            dstIndex += this.writeString(this.lastName.toUpperCase(), dst, dstIndex, false);
        }
        return dstIndex - start;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return "NetServerEnum2[" + super.toString() + ",name=" + this.name + ",serverTypes=" + (this.serverTypes == -1 ? "SV_TYPE_ALL" : "SV_TYPE_DOMAIN_ENUM") + "]";
    }
}

