/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.smb1.com;

import java.io.UnsupportedEncodingException;
import org.codelibs.jcifs.smb.Configuration;
import org.codelibs.jcifs.smb.internal.TreeConnectResponse;
import org.codelibs.jcifs.smb.internal.smb1.AndXServerMessageBlock;
import org.codelibs.jcifs.smb.internal.smb1.ServerMessageBlock;

public class SmbComTreeConnectAndXResponse
extends AndXServerMessageBlock
implements TreeConnectResponse {
    private static final int SMB_SUPPORT_SEARCH_BITS = 1;
    private static final int SMB_SHARE_IS_IN_DFS = 2;
    private boolean supportSearchBits;
    private boolean shareIsInDfs;
    private String service;
    private String nativeFileSystem = "";

    public SmbComTreeConnectAndXResponse(Configuration config, ServerMessageBlock andx) {
        super(config, andx);
    }

    @Override
    public final String getService() {
        return this.service;
    }

    public final String getNativeFileSystem() {
        return this.nativeFileSystem;
    }

    public final boolean isSupportSearchBits() {
        return this.supportSearchBits;
    }

    @Override
    public final boolean isShareDfs() {
        return this.shareIsInDfs;
    }

    @Override
    public boolean isValidTid() {
        return this.getTid() != 65535;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        this.supportSearchBits = (buffer[bufferIndex] & 1) == 1;
        this.shareIsInDfs = (buffer[bufferIndex] & 2) == 2;
        return 2;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        int len = this.readStringLength(buffer, bufferIndex, 32);
        try {
            this.service = new String(buffer, bufferIndex, len, "ASCII");
        }
        catch (UnsupportedEncodingException uee) {
            return 0;
        }
        if (this.byteCount > (bufferIndex += len + 1) - start) {
            try {
                int fsLen = this.byteCount - (bufferIndex - start);
                if (fsLen > 0 && fsLen < 256) {
                    this.nativeFileSystem = this.readString(buffer, bufferIndex);
                    bufferIndex += this.stringWireLength(this.nativeFileSystem, bufferIndex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bufferIndex - start;
    }

    @Override
    public String toString() {
        return "SmbComTreeConnectAndXResponse[" + super.toString() + ",supportSearchBits=" + this.supportSearchBits + ",shareIsInDfs=" + this.shareIsInDfs + ",service=" + this.service + ",nativeFileSystem=" + this.nativeFileSystem + "]";
    }
}

