/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.fscc;

import org.codelibs.jcifs.smb.internal.AllocInfo;
import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class SmbInfoAllocation
implements AllocInfo {
    private long alloc;
    private long free;
    private int sectPerAlloc;
    private int bytesPerSect;

    @Override
    public byte getFileSystemInformationClass() {
        return -1;
    }

    @Override
    public long getCapacity() {
        return this.alloc * (long)this.sectPerAlloc * (long)this.bytesPerSect;
    }

    @Override
    public long getFree() {
        return this.free * (long)this.sectPerAlloc * (long)this.bytesPerSect;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        this.sectPerAlloc = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.alloc = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.free = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.bytesPerSect = SMBUtil.readInt2(buffer, bufferIndex += 4);
        return (bufferIndex += 4) - start;
    }

    public String toString() {
        return "SmbInfoAllocation[alloc=" + this.alloc + ",free=" + this.free + ",sectPerAlloc=" + this.sectPerAlloc + ",bytesPerSect=" + this.bytesPerSect + "]";
    }
}

