/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.internal.fscc;

import org.codelibs.jcifs.smb.internal.SMBProtocolDecodingException;
import org.codelibs.jcifs.smb.internal.fscc.FileInformation;
import org.codelibs.jcifs.smb.internal.util.SMBUtil;

public class FileInternalInfo
implements FileInformation {
    private long indexNumber;

    @Override
    public byte getFileInformationLevel() {
        return 6;
    }

    public long getIndexNumber() {
        return this.indexNumber;
    }

    @Override
    public int decode(byte[] buffer, int bufferIndex, int len) throws SMBProtocolDecodingException {
        this.indexNumber = SMBUtil.readInt8(buffer, bufferIndex);
        return 8;
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public int encode(byte[] dst, int dstIndex) {
        SMBUtil.writeInt8(this.indexNumber, dst, dstIndex);
        return 8;
    }

    public String toString() {
        return "SmbQueryFileInternalInfo[indexNumber=" + this.indexNumber + "]";
    }
}

