/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.impl;

import java.io.IOException;
import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.impl.RequestParam;
import org.codelibs.jcifs.smb.impl.SmbException;
import org.codelibs.jcifs.smb.impl.SmbFileHandleImpl;
import org.codelibs.jcifs.smb.impl.SmbFileInputStream;
import org.codelibs.jcifs.smb.impl.SmbPipeHandleImpl;
import org.codelibs.jcifs.smb.impl.SmbTreeHandleImpl;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.smb1.trans.TransPeekNamedPipe;
import org.codelibs.jcifs.smb.internal.smb1.trans.TransPeekNamedPipeResponse;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.Smb2IoctlRequest;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.Smb2IoctlResponse;
import org.codelibs.jcifs.smb.internal.smb2.ioctl.SrvPipePeekResponse;

public class SmbPipeInputStream
extends SmbFileInputStream {
    private final SmbPipeHandleImpl handle;

    SmbPipeInputStream(SmbPipeHandleImpl handle, SmbTreeHandleImpl th) throws CIFSException {
        super(handle.getPipe(), th, null);
        this.handle = handle;
    }

    protected synchronized SmbTreeHandleImpl ensureTreeConnected() throws CIFSException {
        return this.handle.ensureTreeConnected();
    }

    @Override
    protected synchronized SmbFileHandleImpl ensureOpen() throws CIFSException {
        return this.handle.ensureOpen();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int available() throws IOException {
        try (SmbFileHandleImpl fd = this.handle.ensureOpen();){
            TransPeekNamedPipeResponse resp;
            SmbTreeHandleImpl th;
            block22: {
                block21: {
                    th = fd.getTree();
                    try {
                        if (!th.isSMB2()) break block21;
                        Smb2IoctlRequest req = new Smb2IoctlRequest(th.getConfig(), 1130508, fd.getFileId());
                        req.setMaxOutputResponse(16);
                        req.setFlags(1);
                        Smb2IoctlResponse resp2 = th.send(req, RequestParam.NO_RETRY);
                        int n = ((SrvPipePeekResponse)resp2.getOutputData()).getReadDataAvailable();
                        if (th != null) {
                            th.close();
                        }
                        return n;
                    }
                    catch (Throwable throwable) {
                        if (th != null) {
                            try {
                                th.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                TransPeekNamedPipe req = new TransPeekNamedPipe(th.getConfig(), this.handle.getUncPath(), fd.getFid());
                resp = new TransPeekNamedPipeResponse(th.getConfig());
                th.send((CommonServerMessageBlockRequest)req, resp, RequestParam.NO_RETRY);
                if (resp.getStatus() != 1 && resp.getStatus() != 4) break block22;
                fd.markClosed();
                int n = 0;
                if (th != null) {
                    th.close();
                }
                return n;
            }
            int n = resp.getAvailable();
            if (th != null) {
                th.close();
            }
            return n;
        }
        catch (SmbException se) {
            throw SmbPipeInputStream.seToIoe(se);
        }
    }

    @Override
    public void close() {
    }
}

