/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import org.codelibs.jcifs.smb.Address;
import org.codelibs.jcifs.smb.CIFSContext;
import org.codelibs.jcifs.smb.CIFSException;
import org.codelibs.jcifs.smb.CloseableIterator;
import org.codelibs.jcifs.smb.ResourceFilter;
import org.codelibs.jcifs.smb.ResourceNameFilter;
import org.codelibs.jcifs.smb.SmbResource;
import org.codelibs.jcifs.smb.SmbResourceLocator;
import org.codelibs.jcifs.smb.dcerpc.DcerpcException;
import org.codelibs.jcifs.smb.dcerpc.DcerpcHandle;
import org.codelibs.jcifs.smb.dcerpc.msrpc.MsrpcDfsRootEnum;
import org.codelibs.jcifs.smb.dcerpc.msrpc.MsrpcShareEnum;
import org.codelibs.jcifs.smb.impl.DirFileEntryAdapterIterator;
import org.codelibs.jcifs.smb.impl.DirFileEntryEnumIterator1;
import org.codelibs.jcifs.smb.impl.DirFileEntryEnumIterator2;
import org.codelibs.jcifs.smb.impl.DosFileFilter;
import org.codelibs.jcifs.smb.impl.FileEntry;
import org.codelibs.jcifs.smb.impl.NetServerEnumIterator;
import org.codelibs.jcifs.smb.impl.NetServerFileEntryAdapterIterator;
import org.codelibs.jcifs.smb.impl.RequestParam;
import org.codelibs.jcifs.smb.impl.ShareEnumIterator;
import org.codelibs.jcifs.smb.impl.SmbException;
import org.codelibs.jcifs.smb.impl.SmbFile;
import org.codelibs.jcifs.smb.impl.SmbFileFilter;
import org.codelibs.jcifs.smb.impl.SmbFilenameFilter;
import org.codelibs.jcifs.smb.impl.SmbResourceLocatorImpl;
import org.codelibs.jcifs.smb.impl.SmbSessionImpl;
import org.codelibs.jcifs.smb.impl.SmbTransportImpl;
import org.codelibs.jcifs.smb.impl.SmbTreeConnection;
import org.codelibs.jcifs.smb.impl.SmbTreeHandleImpl;
import org.codelibs.jcifs.smb.impl.SmbUnsupportedOperationException;
import org.codelibs.jcifs.smb.internal.CommonServerMessageBlockRequest;
import org.codelibs.jcifs.smb.internal.smb1.net.NetShareEnum;
import org.codelibs.jcifs.smb.internal.smb1.net.NetShareEnumResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SmbEnumerationUtil {
    private static final Logger log = LoggerFactory.getLogger(SmbEnumerationUtil.class);

    private SmbEnumerationUtil() {
    }

    private static DcerpcHandle getHandle(CIFSContext ctx, SmbResourceLocator loc, Address address, String ep) throws MalformedURLException, DcerpcException {
        return DcerpcHandle.getHandle(String.format("ncacn_np:%s[endpoint=%s,address=%s]", loc.getServer(), ep, address.getHostAddress()), ctx);
    }

    static FileEntry[] doDfsRootEnum(CIFSContext ctx, SmbResourceLocator loc, Address address) throws IOException {
        try (DcerpcHandle handle = SmbEnumerationUtil.getHandle(ctx, loc, address, "\\PIPE\\netdfs");){
            MsrpcDfsRootEnum rpc2 = new MsrpcDfsRootEnum(loc.getServer());
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, true);
            }
            FileEntry[] fileEntryArray = rpc2.getEntries();
            return fileEntryArray;
        }
    }

    static FileEntry[] doMsrpcShareEnum(CIFSContext ctx, SmbResourceLocator loc, Address address) throws IOException {
        try (DcerpcHandle handle = SmbEnumerationUtil.getHandle(ctx, loc, address, "\\PIPE\\srvsvc");){
            MsrpcShareEnum rpc2 = new MsrpcShareEnum(loc.getServer());
            handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, true);
            }
            FileEntry[] fileEntryArray = rpc2.getEntries();
            return fileEntryArray;
        }
    }

    static FileEntry[] doNetShareEnum(SmbTreeHandleImpl th) throws CIFSException {
        NetShareEnum req = new NetShareEnum(th.getConfig());
        NetShareEnumResponse resp = new NetShareEnumResponse(th.getConfig());
        th.send((CommonServerMessageBlockRequest)req, resp, new RequestParam[0]);
        if (resp.getStatus() != 0) {
            throw new SmbException(resp.getStatus(), true);
        }
        return resp.getResults();
    }

    static CloseableIterator<SmbResource> doShareEnum(SmbFile parent, String wildcard, int searchAttributes, ResourceNameFilter fnf, ResourceFilter ff) throws CIFSException {
        FileEntry[] entries;
        SmbResourceLocatorImpl locator = parent.fileLocator.clone();
        CIFSContext tc = parent.getContext();
        URL u = locator.getURL();
        if (u.getPath().lastIndexOf(47) != u.getPath().length() - 1) {
            throw new SmbException(u.toString() + " directory must end with '/'");
        }
        if (locator.getType() != 4) {
            throw new SmbException("The requested list operations is invalid: " + u.toString());
        }
        HashSet<FileEntry> set = new HashSet<FileEntry>();
        if (tc.getDfs().isTrustedDomain(tc, locator.getServer())) {
            try {
                for (FileEntry e : entries = SmbEnumerationUtil.doDfsRootEnum(tc, locator, locator.getAddress())) {
                    if (set.contains(e) || fnf != null && !fnf.accept(parent, e.getName())) continue;
                    set.add(e);
                }
            }
            catch (IOException ioe) {
                log.debug("DS enumeration failed", (Throwable)ioe);
            }
        }
        SmbTreeConnection treeConn = SmbTreeConnection.create(tc);
        try (SmbTreeHandleImpl th = treeConn.connectHost(locator, locator.getServerWithDfs());
             SmbSessionImpl session = th.getSession();
             SmbTransportImpl transport = session.getTransport();){
            try {
                entries = SmbEnumerationUtil.doMsrpcShareEnum(tc, locator, transport.getRemoteAddress());
            }
            catch (IOException ioe) {
                if (th.isSMB2()) {
                    throw ioe;
                }
                log.debug("doMsrpcShareEnum failed", (Throwable)ioe);
                entries = SmbEnumerationUtil.doNetShareEnum(th);
            }
            for (FileEntry e : entries) {
                if (set.contains(e) || fnf != null && !fnf.accept(parent, e.getName())) continue;
                set.add(e);
            }
        }
        catch (SmbException e) {
            throw e;
        }
        catch (IOException ioe) {
            log.debug("doNetShareEnum failed", (Throwable)ioe);
            throw new SmbException(u.toString(), (Throwable)ioe);
        }
        return new ShareEnumIterator(parent, set.iterator(), ff);
    }

    static CloseableIterator<SmbResource> doEnum(SmbFile parent, String wildcard, int searchAttributes, ResourceNameFilter fnf, ResourceFilter ff) throws CIFSException {
        SmbResourceLocator locator;
        DosFileFilter dff = SmbEnumerationUtil.unwrapDOSFilter(ff);
        if (dff != null) {
            if (dff.wildcard != null) {
                wildcard = dff.wildcard;
            }
            searchAttributes = dff.attributes;
        }
        if ((locator = parent.getLocator()).getURL().getHost().isEmpty()) {
            Address addr;
            try {
                addr = locator.getAddress();
            }
            catch (CIFSException e) {
                if (e.getCause() instanceof UnknownHostException) {
                    log.debug("Failed to find master browser", (Throwable)e);
                    throw new SmbUnsupportedOperationException();
                }
                throw e;
            }
            try (SmbFile browser = (SmbFile)parent.resolve(addr.getHostAddress());){
                SmbTreeHandleImpl th = browser.ensureTreeConnected();
                try {
                    if (th.isSMB2()) {
                        throw new SmbUnsupportedOperationException();
                    }
                    NetServerFileEntryAdapterIterator netServerFileEntryAdapterIterator = new NetServerFileEntryAdapterIterator((SmbResource)parent, new NetServerEnumIterator(parent, th, wildcard, searchAttributes, fnf), ff);
                    if (th != null) {
                        th.close();
                    }
                    return netServerFileEntryAdapterIterator;
                }
                catch (Throwable throwable) {
                    if (th != null) {
                        try {
                            th.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
        if (locator.getType() == 2) {
            try (SmbTreeHandleImpl th = parent.ensureTreeConnected();){
                if (th.isSMB2()) {
                    throw new SmbUnsupportedOperationException();
                }
                NetServerFileEntryAdapterIterator netServerFileEntryAdapterIterator = new NetServerFileEntryAdapterIterator((SmbResource)parent, new NetServerEnumIterator(parent, th, wildcard, searchAttributes, fnf), ff);
                return netServerFileEntryAdapterIterator;
            }
        }
        if (locator.isRoot()) {
            return SmbEnumerationUtil.doShareEnum(parent, wildcard, searchAttributes, fnf, ff);
        }
        try (SmbTreeHandleImpl th = parent.ensureTreeConnected();){
            if (th.isSMB2()) {
                DirFileEntryAdapterIterator dirFileEntryAdapterIterator = new DirFileEntryAdapterIterator(parent, new DirFileEntryEnumIterator2(th, parent, wildcard, fnf, searchAttributes), ff);
                return dirFileEntryAdapterIterator;
            }
            DirFileEntryAdapterIterator dirFileEntryAdapterIterator = new DirFileEntryAdapterIterator(parent, new DirFileEntryEnumIterator1(th, parent, wildcard, fnf, searchAttributes), ff);
            return dirFileEntryAdapterIterator;
        }
    }

    private static DosFileFilter unwrapDOSFilter(ResourceFilter ff) {
        SmbFileFilter sff;
        if (ff instanceof ResourceFilterWrapper && (sff = ((ResourceFilterWrapper)ff).getFileFilter()) instanceof DosFileFilter) {
            return (DosFileFilter)sff;
        }
        return null;
    }

    static String[] list(SmbFile root, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException {
        String[] stringArray;
        block14: {
            CloseableIterator<SmbResource> it = SmbEnumerationUtil.doEnum(root, wildcard, searchAttributes, fnf == null ? null : (parent, name) -> {
                if (!(parent instanceof SmbFile)) {
                    return false;
                }
                return fnf.accept((SmbFile)parent, name);
            }, ff == null ? null : resource -> {
                if (!(resource instanceof SmbFile)) {
                    return false;
                }
                return ff.accept((SmbFile)resource);
            });
            try {
                ArrayList<String> list = new ArrayList<String>();
                while (it.hasNext()) {
                    SmbResource n = (SmbResource)it.next();
                    try {
                        list.add(n.getName());
                    }
                    finally {
                        if (n == null) continue;
                        n.close();
                    }
                }
                stringArray = list.toArray(new String[list.size()]);
                if (it == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CIFSException e) {
                    throw SmbException.wrap(e);
                }
            }
            it.close();
        }
        return stringArray;
    }

    static SmbFile[] listFiles(SmbFile root, String wildcard, int searchAttributes, SmbFilenameFilter fnf, SmbFileFilter ff) throws SmbException {
        SmbFile[] smbFileArray;
        block14: {
            CloseableIterator<SmbResource> it = SmbEnumerationUtil.doEnum(root, wildcard, searchAttributes, fnf == null ? null : new ResourceNameFilterWrapper(fnf), ff == null ? null : new ResourceFilterWrapper(ff));
            try {
                ArrayList<SmbFile> list = new ArrayList<SmbFile>();
                while (it.hasNext()) {
                    SmbResource n = (SmbResource)it.next();
                    try {
                        if (!(n instanceof SmbFile)) continue;
                        list.add((SmbFile)n);
                    }
                    finally {
                        if (n == null) continue;
                        n.close();
                    }
                }
                smbFileArray = list.toArray(new SmbFile[list.size()]);
                if (it == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CIFSException e) {
                    throw SmbException.wrap(e);
                }
            }
            it.close();
        }
        return smbFileArray;
    }

    private static final class ResourceFilterWrapper
    implements ResourceFilter {
        private final SmbFileFilter ff;

        ResourceFilterWrapper(SmbFileFilter ff) {
            this.ff = ff;
        }

        SmbFileFilter getFileFilter() {
            return this.ff;
        }

        @Override
        public boolean accept(SmbResource resource) throws CIFSException {
            if (!(resource instanceof SmbFile)) {
                return false;
            }
            return this.ff.accept((SmbFile)resource);
        }
    }

    private static final class ResourceNameFilterWrapper
    implements ResourceNameFilter {
        private final SmbFilenameFilter fnf;

        ResourceNameFilterWrapper(SmbFilenameFilter fnf) {
            this.fnf = fnf;
        }

        @Override
        public boolean accept(SmbResource parent, String name) throws CIFSException {
            if (!(parent instanceof SmbFile)) {
                return false;
            }
            return this.fnf.accept((SmbFile)parent, name);
        }
    }
}

