/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.jcifs.smb.impl;

import org.bouncycastle.util.encoders.Hex;
import org.codelibs.jcifs.smb.impl.NtlmPasswordAuthenticator;

public class NtlmNtHashAuthenticator
extends NtlmPasswordAuthenticator {
    private static final long serialVersionUID = 4328214169536360351L;
    private final byte[] ntHash;

    public NtlmNtHashAuthenticator(String domain, String username, byte[] passwordHash) {
        super(domain, username, null, NtlmPasswordAuthenticator.AuthenticationType.USER);
        if (passwordHash == null || passwordHash.length != 16) {
            throw new IllegalArgumentException("Password hash must be provided, expected length 16 byte");
        }
        this.ntHash = passwordHash;
    }

    public NtlmNtHashAuthenticator(String domain, String username, String passwordHashHex) {
        this(domain, username, Hex.decode((String)passwordHashHex));
    }

    private NtlmNtHashAuthenticator(byte[] passwordHash) {
        this.ntHash = passwordHash;
    }

    @Override
    protected byte[] getNTHash() {
        return this.ntHash;
    }

    @Override
    public NtlmPasswordAuthenticator clone() {
        NtlmNtHashAuthenticator cloned = new NtlmNtHashAuthenticator((byte[])this.ntHash.clone());
        NtlmNtHashAuthenticator.cloneInternal(cloned, this);
        return cloned;
    }
}

