/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.UpdateScope;
import org.codehaus.mojo.versions.api.VersionDetails;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.ordering.VersionComparator;

public abstract class AbstractVersionDetails
implements VersionDetails {
    private ArtifactVersion currentVersion = null;
    private boolean includeSnapshots = false;
    private final Object currentVersionLock = new Object();

    protected AbstractVersionDetails() {
    }

    protected AbstractVersionDetails(ArtifactVersion currentVersion, boolean includeSnapshots) {
        this.currentVersion = currentVersion;
        this.includeSnapshots = includeSnapshots;
    }

    @Override
    public final boolean isCurrentVersionDefined() {
        return this.getCurrentVersion() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ArtifactVersion getCurrentVersion() {
        Object object = this.currentVersionLock;
        synchronized (object) {
            return this.currentVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setCurrentVersion(ArtifactVersion currentVersion) {
        Object object = this.currentVersionLock;
        synchronized (object) {
            this.currentVersion = currentVersion;
        }
    }

    @Override
    public final void setCurrentVersion(String currentVersion) {
        this.setCurrentVersion((ArtifactVersion)(currentVersion == null ? null : new DefaultArtifactVersion(currentVersion)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isIncludeSnapshots() {
        Object object = this.currentVersionLock;
        synchronized (object) {
            return this.includeSnapshots;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setIncludeSnapshots(boolean includeSnapshots) {
        Object object = this.currentVersionLock;
        synchronized (object) {
            this.includeSnapshots = includeSnapshots;
        }
    }

    @Override
    public final ArtifactVersion[] getVersions() {
        return this.getVersions(this.isIncludeSnapshots());
    }

    @Override
    public abstract ArtifactVersion[] getVersions(boolean var1);

    @Override
    public final ArtifactVersion[] getVersions(VersionRange versionRange, boolean includeSnapshots) {
        return this.getVersions(versionRange, null, null, includeSnapshots, true, true);
    }

    @Override
    public final ArtifactVersion[] getVersions(ArtifactVersion currentVersion, ArtifactVersion upperBound) {
        return this.getVersions(currentVersion, upperBound, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion[] getVersions(ArtifactVersion currentVersion, ArtifactVersion upperBound, boolean includeSnapshots) {
        return this.getVersions(currentVersion, upperBound, includeSnapshots, false, false);
    }

    private ArtifactVersion[] getNewerVersions(ArtifactVersion version, boolean includeSnapshots) {
        return this.getVersions(version, null, includeSnapshots, false, true);
    }

    @Override
    public final ArtifactVersion getNewestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound) {
        return this.getNewestVersion(lowerBound, upperBound, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion getNewestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots) {
        return this.getNewestVersion(lowerBound, upperBound, includeSnapshots, false, false);
    }

    @Override
    public final ArtifactVersion getNewestVersion(VersionRange versionRange, ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        return this.getNewestVersion(versionRange, lowerBound, upperBound, includeSnapshots, includeLower, includeUpper, false);
    }

    private static <T> Iterable<T> reverse(T[] array) {
        return Arrays.stream(array).sorted(Collections.reverseOrder()).collect(Collectors.toList());
    }

    public final ArtifactVersion getNewestVersion(VersionRange versionRange, ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper, boolean allowDowngrade) {
        VersionComparator versionComparator = this.getVersionComparator();
        for (ArtifactVersion candidate : AbstractVersionDetails.reverse(this.getVersions(includeSnapshots))) {
            int upper;
            if (!allowDowngrade && versionRange != null && !ArtifactVersions.isVersionInRange(candidate, versionRange)) continue;
            int lower = lowerBound == null ? -1 : versionComparator.compare(lowerBound, candidate);
            int n = upper = upperBound == null ? 1 : versionComparator.compare(upperBound, candidate);
            if (lower > 0 || upper < 0 || !includeLower && lower == 0 || !includeUpper && upper == 0 || !includeSnapshots && ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
            return candidate;
        }
        return null;
    }

    @Override
    public final ArtifactVersion getNewestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        return this.getNewestVersion(null, lowerBound, upperBound, includeSnapshots, includeLower, includeUpper);
    }

    @Override
    public final ArtifactVersion getNewestVersion(VersionRange versionRange, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, null, null, includeSnapshots, true, true);
    }

    @Override
    public final boolean containsVersion(String version) {
        for (ArtifactVersion candidate : this.getVersions(true)) {
            if (!version.equals(candidate.toString())) continue;
            return true;
        }
        return false;
    }

    public final ArtifactVersion[] getNewerVersions(String version, boolean includeSnapshots) {
        return this.getNewerVersions((ArtifactVersion)new DefaultArtifactVersion(version), includeSnapshots);
    }

    @Deprecated
    public final ArtifactVersion[] getNewerVersions(String version, int upperBoundSegment, boolean includeSnapshots) throws InvalidSegmentException {
        return this.getNewerVersions(version, upperBoundSegment, includeSnapshots, false);
    }

    public final ArtifactVersion[] getNewerVersions(String versionString, int upperBoundSegment, boolean includeSnapshots, boolean allowDowngrade) throws InvalidSegmentException {
        DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(versionString);
        DefaultArtifactVersion lowerBound = allowDowngrade ? this.getLowerBoundArtifactVersion((ArtifactVersion)currentVersion, upperBoundSegment) : currentVersion;
        ArtifactVersion upperBound = upperBoundSegment == -1 ? null : this.getVersionComparator().incrementSegment((ArtifactVersion)lowerBound, upperBoundSegment);
        return this.getVersions((ArtifactVersion)lowerBound, upperBound, includeSnapshots, allowDowngrade, allowDowngrade);
    }

    @Override
    public final ArtifactVersion getOldestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound) {
        return this.getOldestVersion(lowerBound, upperBound, true);
    }

    @Override
    public final ArtifactVersion getOldestVersion(VersionRange versionRange, boolean includeSnapshots) {
        return this.getOldestVersion(versionRange, null, null, includeSnapshots, true, true);
    }

    @Override
    public final ArtifactVersion getOldestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots) {
        return this.getOldestVersion(lowerBound, upperBound, includeSnapshots, false, false);
    }

    @Override
    public final ArtifactVersion getOldestVersion(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        return this.getOldestVersion(null, lowerBound, upperBound, includeSnapshots, includeLower, includeUpper);
    }

    @Override
    public final ArtifactVersion getOldestVersion(VersionRange versionRange, ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        ArtifactVersion oldest = null;
        VersionComparator versionComparator = this.getVersionComparator();
        for (ArtifactVersion candidate : this.getVersions(includeSnapshots)) {
            int upper;
            if (versionRange != null && !ArtifactVersions.isVersionInRange(candidate, versionRange)) continue;
            int lower = lowerBound == null ? -1 : versionComparator.compare(lowerBound, candidate);
            int n = upper = upperBound == null ? 1 : versionComparator.compare(upperBound, candidate);
            if (lower > 0 || upper < 0 || !includeLower && lower == 0 || !includeUpper && upper == 0 || !includeSnapshots && ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
            if (oldest == null) {
                oldest = candidate;
                continue;
            }
            if (versionComparator.compare(oldest, candidate) <= 0) continue;
            oldest = candidate;
        }
        return oldest;
    }

    @Override
    public final ArtifactVersion[] getVersions(ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        return this.getVersions(null, lowerBound, upperBound, includeSnapshots, includeLower, includeUpper);
    }

    @Override
    public final ArtifactVersion[] getVersions(VersionRange versionRange, ArtifactVersion lowerBound, ArtifactVersion upperBound, boolean includeSnapshots, boolean includeLower, boolean includeUpper) {
        VersionComparator versionComparator = this.getVersionComparator();
        TreeSet<ArtifactVersion> result = new TreeSet<ArtifactVersion>(versionComparator);
        for (ArtifactVersion candidate : this.getVersions(includeSnapshots)) {
            int upper;
            if (versionRange != null && !ArtifactVersions.isVersionInRange(candidate, versionRange)) continue;
            int lower = lowerBound == null ? -1 : versionComparator.compare(lowerBound, candidate);
            int n = upper = upperBound == null ? 1 : versionComparator.compare(upperBound, candidate);
            if (lower > 0 || upper < 0 || !includeLower && lower == 0 || !includeUpper && upper == 0 || !includeSnapshots && ArtifactUtils.isSnapshot((String)candidate.toString())) continue;
            result.add(candidate);
        }
        return result.toArray(new ArtifactVersion[0]);
    }

    @Override
    public final ArtifactVersion getOldestUpdate(ArtifactVersion currentVersion, UpdateScope updateScope) throws InvalidSegmentException {
        return this.getOldestUpdate(currentVersion, updateScope, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion getNewestUpdate(ArtifactVersion currentVersion, UpdateScope updateScope) throws InvalidSegmentException {
        return this.getNewestUpdate(currentVersion, updateScope, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, UpdateScope updateScope) throws InvalidSegmentException {
        return this.getAllUpdates(currentVersion, updateScope, this.isIncludeSnapshots());
    }

    @Override
    public ArtifactVersion getOldestUpdate(ArtifactVersion currentVersion, VersionRange versionRange) {
        return this.getOldestUpdate(currentVersion, versionRange, this.isIncludeSnapshots());
    }

    @Override
    public ArtifactVersion getNewestUpdate(ArtifactVersion currentVersion, VersionRange versionRange) {
        return this.getNewestUpdate(currentVersion, versionRange, this.isIncludeSnapshots());
    }

    @Override
    public ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, VersionRange versionRange) {
        return this.getAllUpdates(currentVersion, versionRange, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion getOldestUpdate(ArtifactVersion currentVersion, UpdateScope updateScope, boolean includeSnapshots) {
        return updateScope.getOldestUpdate(this, currentVersion, includeSnapshots);
    }

    @Override
    public final ArtifactVersion getNewestUpdate(ArtifactVersion currentVersion, UpdateScope updateScope, boolean includeSnapshots) {
        return updateScope.getNewestUpdate(this, currentVersion, includeSnapshots);
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, UpdateScope updateScope, boolean includeSnapshots) {
        return updateScope.getAllUpdates(this, currentVersion, includeSnapshots);
    }

    @Override
    public ArtifactVersion getOldestUpdate(ArtifactVersion currentVersion, VersionRange versionRange, boolean includeSnapshots) {
        return this.getOldestVersion(versionRange, includeSnapshots);
    }

    @Override
    public ArtifactVersion getNewestUpdate(ArtifactVersion currentVersion, VersionRange versionRange, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, includeSnapshots);
    }

    @Override
    public ArtifactVersion[] getAllUpdates(ArtifactVersion currentVersion, VersionRange versionRange, boolean includeSnapshots) {
        return new ArtifactVersion[0];
    }

    @Override
    public final ArtifactVersion getOldestUpdate(UpdateScope updateScope) {
        return this.getOldestUpdate(updateScope, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion getNewestUpdate(UpdateScope updateScope) {
        return this.getNewestUpdate(updateScope, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(UpdateScope updateScope) {
        return this.getAllUpdates(updateScope, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion getOldestUpdate(UpdateScope updateScope, boolean includeSnapshots) {
        if (this.isCurrentVersionDefined()) {
            return this.getOldestUpdate(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    @Override
    public final ArtifactVersion getNewestUpdate(UpdateScope updateScope, boolean includeSnapshots) {
        if (this.isCurrentVersionDefined()) {
            return this.getNewestUpdate(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(UpdateScope updateScope, boolean includeSnapshots) {
        if (this.isCurrentVersionDefined()) {
            return this.getAllUpdates(this.getCurrentVersion(), updateScope, includeSnapshots);
        }
        return null;
    }

    @Override
    public final ArtifactVersion getOldestUpdate(VersionRange versionRange) {
        return this.getOldestUpdate(versionRange, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion getNewestUpdate(VersionRange versionRange) {
        return this.getNewestUpdate(versionRange, this.isIncludeSnapshots());
    }

    @Override
    public final ArtifactVersion[] getAllUpdates(VersionRange versionRange) {
        return this.getAllUpdates(versionRange, this.isIncludeSnapshots());
    }

    @Override
    public ArtifactVersion getOldestUpdate(VersionRange versionRange, boolean includeSnapshots) {
        return this.getOldestVersion(versionRange, this.getCurrentVersion(), null, includeSnapshots, false, true);
    }

    @Override
    public ArtifactVersion getNewestUpdate(VersionRange versionRange, boolean includeSnapshots) {
        return this.getNewestVersion(versionRange, this.getCurrentVersion(), null, includeSnapshots, false, true);
    }

    @Override
    public ArtifactVersion[] getAllUpdates(VersionRange versionRange, boolean includeSnapshots) {
        return this.getVersions(versionRange, this.getCurrentVersion(), null, includeSnapshots, false, true);
    }

    protected ArtifactVersion getLowerBoundArtifactVersion(ArtifactVersion version, int unchangedSegment) throws InvalidSegmentException {
        Optional<String> lowerBound = this.getLowerBound(version, unchangedSegment);
        return lowerBound.map(DefaultArtifactVersion::new).orElse(null);
    }

    protected Optional<String> getLowerBound(ArtifactVersion version, int unchangedSegment) throws InvalidSegmentException {
        if (unchangedSegment < 0) {
            return Optional.empty();
        }
        int segmentCount = this.getVersionComparator().getSegmentCount(version);
        if (unchangedSegment > segmentCount) {
            throw new InvalidSegmentException(unchangedSegment, segmentCount, version);
        }
        StringBuilder newVersion = new StringBuilder();
        newVersion.append(version.getMajorVersion());
        if (segmentCount > 0) {
            newVersion.append(".").append(unchangedSegment >= 1 ? version.getMinorVersion() : 0);
        }
        if (segmentCount > 1) {
            newVersion.append(".").append(unchangedSegment >= 2 ? version.getIncrementalVersion() : 0);
        }
        if (segmentCount > 2) {
            if (version.getQualifier() != null) {
                newVersion.append("-").append(unchangedSegment >= 3 ? version.getQualifier() : "0");
            } else {
                newVersion.append("-").append(unchangedSegment >= 3 ? Integer.valueOf(version.getBuildNumber()) : "0");
            }
        }
        return Optional.of(newVersion.toString());
    }
}

