/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.enforcer.Hasher;

public class ClassFile {
    private final String classFilePath;
    private final Artifact artifactThisClassWasFoundIn;
    private final Hasher hasher;
    private String lazilyComputedHash;

    public ClassFile(String classFilePath, Artifact artifactThisClassWasFoundIn) {
        this.classFilePath = classFilePath;
        this.artifactThisClassWasFoundIn = artifactThisClassWasFoundIn;
        this.hasher = new Hasher(classFilePath);
    }

    public String getClassFilePath() {
        return this.classFilePath;
    }

    public Artifact getArtifactThisClassWasFoundIn() {
        return this.artifactThisClassWasFoundIn;
    }

    public String getHash() {
        if (this.lazilyComputedHash == null) {
            this.lazilyComputedHash = this.hasher.generateHash(this.artifactThisClassWasFoundIn);
        }
        return this.lazilyComputedHash;
    }
}

