/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugins.xml.metadata;

import java.util.Map;
import org.codehaus.modello.metadata.AbstractMetadataPlugin;
import org.codehaus.modello.metadata.AssociationMetadata;
import org.codehaus.modello.metadata.ClassMetadata;
import org.codehaus.modello.metadata.FieldMetadata;
import org.codehaus.modello.metadata.InterfaceMetadata;
import org.codehaus.modello.metadata.MetadataPlugin;
import org.codehaus.modello.metadata.ModelMetadata;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.ModelInterface;
import org.codehaus.modello.plugins.xml.metadata.XmlAssociationMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlClassMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlFieldMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlInterfaceMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlModelMetadata;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=MetadataPlugin.class, hint="xml")
public class XmlMetadataPlugin
extends AbstractMetadataPlugin
implements MetadataPlugin {
    public static final String XML_ATTRIBUTE = "xml.attribute";
    public static final String XML_CONTENT = "xml.content";
    public static final String XML_FORMAT = "xml.format";
    public static final String XML_ITEMS_STYLE = "xml.itemsStyle";
    public static final String XML_MAP_STYLE = "xml.mapStyle";
    public static final String XML_NAMESPACE = "xml.namespace";
    public static final String XML_REFERENCE = "xml.reference";
    public static final String XML_SCHEMA_LOCATION = "xml.schemaLocation";
    public static final String XML_TAG_NAME = "xml.tagName";
    public static final String XML_STANDALONE_READ = "xml.standaloneRead";
    public static final String XML_TRIM = "xml.trim";
    public static final String XML_TRANSIENT = "xml.transient";
    public static final String XML_INSERT_PARENT_FIELDS_UP_TO = "xml.insertParentFieldsUpTo";

    public ModelMetadata getModelMetadata(Model model, Map<String, String> data) {
        XmlModelMetadata metadata = new XmlModelMetadata();
        metadata.setNamespace(this.getString(data, XML_NAMESPACE));
        metadata.setSchemaLocation(this.getString(data, XML_SCHEMA_LOCATION));
        return metadata;
    }

    public ClassMetadata getClassMetadata(ModelClass clazz, Map<String, String> data) {
        XmlClassMetadata metadata = new XmlClassMetadata();
        metadata.setTagName(this.getString(data, XML_TAG_NAME));
        metadata.setStandaloneRead(this.getBoolean(data, XML_STANDALONE_READ, false));
        return metadata;
    }

    public InterfaceMetadata getInterfaceMetadata(ModelInterface iface, Map<String, String> data) {
        return new XmlInterfaceMetadata();
    }

    public FieldMetadata getFieldMetadata(ModelField field, Map<String, String> data) {
        XmlFieldMetadata metadata = new XmlFieldMetadata();
        metadata.setAttribute(this.getBoolean(data, XML_ATTRIBUTE, false));
        metadata.setContent(this.getBoolean(data, XML_CONTENT, false));
        metadata.setTrim(this.getBoolean(data, XML_TRIM, true));
        metadata.setTagName(this.getString(data, XML_TAG_NAME));
        metadata.setFormat(this.getString(data, XML_FORMAT));
        metadata.setTransient(this.getBoolean(data, XML_TRANSIENT, false));
        metadata.setInsertParentFieldsUpTo(this.getString(data, XML_INSERT_PARENT_FIELDS_UP_TO));
        return metadata;
    }

    public AssociationMetadata getAssociationMetadata(ModelAssociation association, Map<String, String> data) {
        XmlAssociationMetadata metadata = new XmlAssociationMetadata();
        metadata.setTagName(this.getString(data, XML_TAG_NAME));
        metadata.setItemsStyle(this.getString(data, XML_ITEMS_STYLE));
        metadata.setMapStyle(this.getString(data, XML_MAP_STYLE));
        metadata.setReference(this.getBoolean(data, XML_REFERENCE, false));
        return metadata;
    }
}

