/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.codehaus.jackson.map.ser.StdSerializerFactory;
import org.codehaus.jackson.map.ser.WritableBeanProperty;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializerFactory
extends SerializerFactory {
    public static final BeanSerializerFactory instance = new BeanSerializerFactory();

    protected BeanSerializerFactory() {
    }

    @Override
    public <T> JsonSerializer<T> createSerializer(Class<T> type) {
        StdSerializerFactory stdF = StdSerializerFactory.instance;
        JsonSerializer<?> ser = stdF.findSerializerByLookup(type);
        if (ser == null && (ser = stdF.findSerializerByPrimaryType(type)) == null && (ser = this.findBeanSerializer(type)) == null) {
            ser = stdF.findSerializerByAddonType(type);
        }
        return ser;
    }

    public JsonSerializer<?> findBeanSerializer(Class<?> type) {
        if (!this.isPotentialBeanType(type)) {
            return null;
        }
        Collection<WritableBeanProperty> props = this.findBeanProperties(type);
        if (props == null || props.size() == 0) {
            return null;
        }
        return new BeanSerializer(type, props);
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        return ClassUtil.canBeABeanType(type) == null && !ClassUtil.isProxyType(type);
    }

    protected Collection<WritableBeanProperty> findBeanProperties(Class<?> type) {
        LinkedHashMap<String, Method> methods = new LinkedHashMap<String, Method>();
        this.findCandidateMethods(type, methods);
        if (methods.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, WritableBeanProperty> props = new LinkedHashMap<String, WritableBeanProperty>();
        for (Method m : methods.values()) {
            WritableBeanProperty prev;
            WritableBeanProperty p = this.convertToProperty(m);
            if (p == null || (prev = props.put(p.getName(), p)) == null) continue;
            throw new IllegalArgumentException("Duplicate property '" + p.getName() + "' for class " + type);
        }
        return props.values();
    }

    protected void findCandidateMethods(Class<?> type, Map<String, Method> result) {
        Class<?> parent = type.getSuperclass();
        if (parent != null && parent != Object.class) {
            this.findCandidateMethods(parent, result);
        }
        for (Method m : type.getDeclaredMethods()) {
            if (!this.okSignatureForAccessor(m)) continue;
            result.put(m.getName(), m);
        }
    }

    protected boolean okSignatureForAccessor(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        Class<?>[] pts = m.getParameterTypes();
        if (pts != null && pts.length > 0) {
            return false;
        }
        Class<?> rt = m.getReturnType();
        return rt != Void.TYPE;
    }

    protected WritableBeanProperty convertToProperty(Method m) {
        String name = this.okNameForAccessor(m);
        if (name != null && (m = this.checkAccess(m, name)) != null) {
            return new WritableBeanProperty(name, m);
        }
        return null;
    }

    protected String okNameForAccessor(Method m) {
        String name = m.getName();
        if (!Modifier.isPublic(m.getModifiers())) {
            return null;
        }
        if (name.startsWith("get")) {
            if ("getClass".equals(m.getName()) && m.getDeclaringClass() == Object.class) {
                return null;
            }
            return this.mangleName(m, name.substring(3));
        }
        if (name.startsWith("is")) {
            Class<?> rt = m.getReturnType();
            if (rt != Boolean.class && rt != Boolean.TYPE) {
                return null;
            }
            return ClassUtil.manglePropertyName(name.substring(2));
        }
        return null;
    }

    protected String mangleName(Method method, String basename) {
        return ClassUtil.manglePropertyName(basename);
    }

    protected Method checkAccess(Method m, String name) {
        ClassUtil.checkAndFixAccess(m, m.getDeclaringClass());
        return m;
    }
}

