/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Calendar;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StdDeserializer<T>
extends JsonDeserializer<T> {
    final Class<?> _valueClass;

    protected StdDeserializer(Class<?> vc) {
        this._valueClass = vc;
    }

    public Class<?> getValueClass() {
        return this._valueClass;
    }

    protected int _parseInt(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return jp.getIntValue();
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getIntValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            try {
                return Integer.parseInt(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid representation of integral number value");
            }
        }
        throw ctxt.mappingException(this._valueClass);
    }

    protected double _parseDouble(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            return jp.getDoubleValue();
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return jp.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text = jp.getText().trim();
            try {
                return Double.parseDouble(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid double value");
            }
        }
        throw ctxt.mappingException(this._valueClass);
    }

    protected java.util.Date _parseDate(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        try {
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return new java.util.Date(jp.getLongValue());
            }
            if (t == JsonToken.VALUE_STRING) {
                return ctxt.parseDate(jp.getText());
            }
            throw ctxt.mappingException(this._valueClass);
        }
        catch (IllegalArgumentException iae) {
            throw ctxt.weirdStringException(this._valueClass, "not a valid representation (error: " + iae.getMessage() + ")");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SqlDateDeserializer
    extends StdDeserializer<Date> {
        public SqlDateDeserializer() {
            super(Date.class);
        }

        @Override
        public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            try {
                if (t == JsonToken.VALUE_NUMBER_INT) {
                    return new Date(jp.getLongValue());
                }
                if (t == JsonToken.VALUE_STRING) {
                    return Date.valueOf(jp.getText().trim());
                }
                throw ctxt.mappingException(this._valueClass);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid representation (error: " + iae.getMessage() + ")");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UtilDateDeserializer
    extends StdDeserializer<java.util.Date> {
        public UtilDateDeserializer() {
            super(java.util.Date.class);
        }

        @Override
        public java.util.Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this._parseDate(jp, ctxt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CalendarDeserializer
    extends StdDeserializer<Calendar> {
        public CalendarDeserializer() {
            super(Calendar.class);
        }

        @Override
        public Calendar deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ctxt.constructCalendar(this._parseDate(jp, ctxt));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BigIntegerDeserializer
    extends StdDeserializer<BigInteger> {
        public BigIntegerDeserializer() {
            super(BigInteger.class);
        }

        @Override
        public BigInteger deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                switch (jp.getNumberType()) {
                    case INT: 
                    case LONG: {
                        return BigInteger.valueOf(jp.getLongValue());
                    }
                }
            } else {
                if (t == JsonToken.VALUE_NUMBER_FLOAT) {
                    return jp.getDecimalValue().toBigInteger();
                }
                if (t != JsonToken.VALUE_STRING) {
                    throw ctxt.mappingException(this._valueClass);
                }
            }
            String text = jp.getText().trim();
            try {
                return new BigInteger(text);
            }
            catch (IllegalArgumentException iae) {
                throw ctxt.weirdStringException(this._valueClass, "not a valid representation");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BigDecimalDeserializer
    extends StdDeserializer<BigDecimal> {
        public BigDecimalDeserializer() {
            super(BigDecimal.class);
        }

        @Override
        public BigDecimal deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
                return jp.getDecimalValue();
            }
            if (t == JsonToken.VALUE_STRING) {
                String text = jp.getText().trim();
                try {
                    return new BigDecimal(text);
                }
                catch (IllegalArgumentException iae) {
                    throw ctxt.weirdStringException(this._valueClass, "not a valid representation");
                }
            }
            throw ctxt.mappingException(this._valueClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoubleDeserializer
    extends StdDeserializer<Double> {
        public DoubleDeserializer() {
            super(Double.class);
        }

        @Override
        public Double deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this._parseDouble(jp, ctxt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FloatDeserializer
    extends StdDeserializer<Float> {
        public FloatDeserializer() {
            super(Float.class);
        }

        @Override
        public Float deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return Float.valueOf((float)this._parseDouble(jp, ctxt));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LongDeserializer
    extends StdDeserializer<Long> {
        public LongDeserializer() {
            super(Long.class);
        }

        @Override
        public Long deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return jp.getLongValue();
            }
            if (t == JsonToken.VALUE_NUMBER_FLOAT) {
                return jp.getLongValue();
            }
            if (t == JsonToken.VALUE_STRING) {
                String text = jp.getText().trim();
                try {
                    return Long.parseLong(text);
                }
                catch (IllegalArgumentException iae) {
                    throw ctxt.weirdStringException(this._valueClass, "not a valid long value");
                }
            }
            throw ctxt.mappingException(this._valueClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IntegerDeserializer
    extends StdDeserializer<Integer> {
        public IntegerDeserializer() {
            super(Integer.class);
        }

        @Override
        public Integer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this._parseInt(jp, ctxt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CharacterDeserializer
    extends StdDeserializer<Character> {
        public CharacterDeserializer() {
            super(Character.class);
        }

        @Override
        public Character deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String text;
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                int value = jp.getIntValue();
                if (value >= 0 && value <= 65535) {
                    return Character.valueOf((char)value);
                }
            } else if (t == JsonToken.VALUE_STRING && (text = jp.getText()).length() == 1) {
                return Character.valueOf(text.charAt(0));
            }
            throw ctxt.mappingException(this._valueClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ShortDeserializer
    extends StdDeserializer<Short> {
        public ShortDeserializer() {
            super(Short.class);
        }

        @Override
        public Short deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            int value = this._parseInt(jp, ctxt);
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw ctxt.weirdStringException(this._valueClass, "overflow, value can not be represented as 16-bit value");
            }
            return (short)value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ByteDeserializer
    extends StdDeserializer<Byte> {
        public ByteDeserializer() {
            super(Byte.class);
        }

        @Override
        public Byte deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            int value = this._parseInt(jp, ctxt);
            if (value < -128 || value > 127) {
                throw ctxt.weirdStringException(this._valueClass, "overflow, value can not be represented as 8-bit value");
            }
            return (byte)value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BooleanDeserializer
    extends StdDeserializer<Boolean> {
        public BooleanDeserializer() {
            super(Boolean.class);
        }

        @Override
        public Boolean deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_TRUE) {
                return Boolean.TRUE;
            }
            if (t == JsonToken.VALUE_FALSE) {
                return Boolean.FALSE;
            }
            if (t == JsonToken.VALUE_STRING) {
                String text = jp.getText();
                if ("true".equals(text)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(text)) {
                    return Boolean.FALSE;
                }
                throw ctxt.weirdStringException(this._valueClass, "only \"true\" or \"false\" recognized");
            }
            throw ctxt.mappingException(this._valueClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StringDeserializer
    extends StdDeserializer<String> {
        public StringDeserializer() {
            super(String.class);
        }

        @Override
        public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken curr = jp.getCurrentToken();
            if (curr == JsonToken.VALUE_STRING) {
                return jp.getText();
            }
            if (curr.isScalarValue()) {
                return jp.getText();
            }
            throw ctxt.mappingException(this._valueClass);
        }
    }
}

