/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.config.Config;
import com.izforge.izpack.api.config.Options;
import com.izforge.izpack.api.data.Info;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.installer.console.ConsoleAction;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanelView;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Logger;

class GeneratePropertiesAction
extends ConsoleAction {
    private static final Logger logger = Logger.getLogger(GeneratePropertiesAction.class.getName());
    private final Options options;
    private final String path;

    public GeneratePropertiesAction(InstallData installData, String path) throws FileNotFoundException {
        super(installData);
        Info info = installData.getInfo();
        this.options = new Options();
        Config config = this.options.getConfig();
        config.setEmptyLines(true);
        config.setHeaderComment(true);
        config.setFileEncoding(Charset.forName("ISO-8859-1"));
        this.options.setHeaderComment(Arrays.asList(info.getAppName() + " " + info.getAppVersion()));
        this.path = path;
    }

    @Override
    public boolean isInstall() {
        return false;
    }

    @Override
    public boolean run(ConsolePanelView panel) {
        return ((ConsolePanel)panel.getView()).generateOptions(this.getInstallData(), this.options);
    }

    @Override
    public boolean complete() {
        try {
            this.options.store(new File(this.path));
        }
        catch (IOException e) {
            logger.severe("Error saving the option file.");
            return false;
        }
        return true;
    }
}

