/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.util.compress;

import com.izforge.izpack.util.compress.SevenZArchiveInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.tika.Tika;

public class ArchiveStreamFactory
extends org.apache.commons.compress.archivers.ArchiveStreamFactory {
    private static final Logger logger = Logger.getLogger(ArchiveStreamFactory.class.getName());

    public ArchiveInputStream createArchiveInputStream(File file, InputStream in) throws ArchiveException {
        try {
            String mimeType = new Tika().detect(file);
            if ("application/x-7z-compressed".equals(mimeType)) {
                return new SevenZArchiveInputStream(file);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not detect mime type of or open archive " + file + ": " + e.getMessage(), e);
        }
        return super.createArchiveInputStream(in);
    }
}

