/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AntPathMatcher {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\$\\{([^/]+?)\\}");

    public boolean match(String pattern, String path, boolean caseSensitive) {
        pattern = pattern.replaceAll("\\\\", "/");
        pattern = pattern.replaceAll("\\.", "\\\\.");
        pattern = pattern.replaceAll("\\*", "[^/]*");
        pattern = pattern.replaceAll("(\\[\\^/\\]\\*){2}", ".*");
        pattern = pattern.replaceAll("/\\.\\*", "(/.*)*");
        pattern = this.unifyVarReferences(pattern);
        pattern = pattern.replaceAll("\\$", "\\\\\\$");
        path = this.unifyVarReferences(path);
        int flags = 0;
        if (!caseSensitive) {
            flags |= 2;
        }
        Pattern p = Pattern.compile(pattern, flags);
        return p.matcher(path).matches();
    }

    private String unifyVarReferences(String input) {
        Matcher m = VAR_PATTERN.matcher(input);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(s, "\\$" + m.group(1));
        }
        m.appendTail(s);
        return s.toString();
    }
}

