/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.packager.impl;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackCompression;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.PackInfo;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.compiler.data.CompilerData;
import com.izforge.izpack.compiler.listener.PackagerListener;
import com.izforge.izpack.compiler.merge.CompilerPathResolver;
import com.izforge.izpack.compiler.packager.impl.PackagerBase;
import com.izforge.izpack.merge.MergeManager;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import com.izforge.izpack.util.NoCloseOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAOutputStream;

public class Packager
extends PackagerBase {
    private static final Logger logger = Logger.getLogger(Packager.class.getName());
    private final CompilerData compilerData;

    public Packager(Properties properties, PackagerListener listener, JarOutputStream jarOutputStream, MergeManager mergeManager, CompilerPathResolver pathResolver, MergeableResolver mergeableResolver, CompilerData compilerData, RulesEngine rulesEngine) {
        super(properties, listener, jarOutputStream, mergeManager, pathResolver, mergeableResolver, compilerData, rulesEngine);
        this.compilerData = compilerData;
    }

    private JarOutputStream getJarOutputStream(File jarFile) throws IOException {
        FileUtils.deleteQuietly((File)jarFile);
        if (this.compilerData.isMkdirs()) {
            FileUtils.forceMkdirParent((File)jarFile);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(jarFile);
        JarOutputStream jarOutputStream = new JarOutputStream(fileOutputStream);
        int level = this.compilerData.getComprLevel();
        if (level >= 0 && level < 10) {
            jarOutputStream.setLevel(level);
        } else {
            jarOutputStream.setLevel(9);
        }
        return jarOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writePacks() throws IOException {
        List<PackInfo> packs = this.getPacksList();
        int num = packs.size();
        this.sendMsg("Writing " + num + " Pack" + (num > 1 ? "s" : "") + " into installer");
        HashMap<File, PackFile> storedFiles = new HashMap<File, PackFile>();
        ArrayList<PackFile> pack200Files = new ArrayList<PackFile>();
        JarOutputStream installerJar = this.getInstallerJar();
        int packNumber = 0;
        XMLElementImpl root = new XMLElementImpl("packs");
        for (PackInfo packInfo : packs) {
            ZipEntry entry;
            Pack pack = packInfo.getPack();
            pack.setFileSize(0L);
            this.sendMsg("Writing Pack " + packNumber + ": " + pack.getName(), 3);
            String streamResourceName = "packs/pack-" + pack.getName();
            JarOutputStream packJar = installerJar;
            if (this.packSeparateJars()) {
                String jarFile = this.getInfo().getInstallerBase() + ".pack-" + pack.getName() + ".jar";
                packJar = this.getJarOutputStream(new File(jarFile));
                entry = new ZipEntry(streamResourceName);
            } else {
                entry = new ZipEntry("resources/" + streamResourceName);
            }
            packJar.putNextEntry(entry);
            packJar.flush();
            CountingOutputStream packOutputStream = new CountingOutputStream((OutputStream)new NoCloseOutputStream((OutputStream)new BufferedOutputStream(packJar)));
            try {
                for (PackFile packFile : packInfo.getPackFiles()) {
                    block29: {
                        File file;
                        block31: {
                            block32: {
                                block30: {
                                    boolean addFile = !pack.isLoose();
                                    file = packInfo.getFile(packFile);
                                    boolean pack200 = packFile.isPack200Jar();
                                    PackFile linkedPackFile = (PackFile)storedFiles.get(file);
                                    if (linkedPackFile != null && !this.packSeparateJars()) {
                                        logger.fine("File " + packFile.getTargetPath() + " is a backreference, linked to " + linkedPackFile.getTargetPath());
                                        packFile.setLinkedPackFile(linkedPackFile);
                                        addFile = false;
                                    }
                                    if (!addFile || packFile.isDirectory()) break block29;
                                    if (!pack200) break block30;
                                    packFile.setStreamResourceName("packs/pack200-" + packFile.getId());
                                    packFile.setStreamOffset(0L);
                                    pack200Files.add(packFile);
                                    break block31;
                                }
                                packFile.setStreamResourceName(streamResourceName);
                                packFile.setStreamOffset(packOutputStream.getByteCount());
                                PackCompression comprFormat = this.getInfo().getCompressionFormat();
                                if (comprFormat == PackCompression.DEFAULT) break block32;
                                File tmpfile = null;
                                LZMAOutputStream finalStream = null;
                                try {
                                    tmpfile = File.createTempFile("izpack-compress", null, FileUtils.getTempDirectory());
                                    CountingOutputStream proxyOutputStream = new CountingOutputStream((OutputStream)FileUtils.openOutputStream((File)tmpfile));
                                    BufferedOutputStream bufferedStream = IOUtils.buffer((OutputStream)proxyOutputStream);
                                    switch (comprFormat) {
                                        case LZMA: {
                                            finalStream = new LZMAOutputStream((OutputStream)bufferedStream, new LZMA2Options(), -1L);
                                            break;
                                        }
                                        case DEFLATE: {
                                            DeflateParameters deflateParameters = new DeflateParameters();
                                            deflateParameters.setCompressionLevel(9);
                                            new DeflateCompressorOutputStream((OutputStream)bufferedStream, deflateParameters);
                                        }
                                        default: {
                                            try {
                                                finalStream = new CompressorStreamFactory().createCompressorOutputStream(comprFormat.toName(), (OutputStream)bufferedStream);
                                                break;
                                            }
                                            catch (CompressorException e) {
                                                throw new IOException(e);
                                            }
                                        }
                                    }
                                    long bytesWritten = FileUtils.copyFile((File)file, (OutputStream)finalStream);
                                    try {
                                        finalStream.flush();
                                    }
                                    catch (IOException ignored) {
                                        // empty catch block
                                    }
                                    finalStream.close();
                                    if (bytesWritten != packFile.length()) {
                                        throw new IOException("File size mismatch when reading " + file);
                                    }
                                    packFile.setSize(proxyOutputStream.getByteCount());
                                    FileUtils.copyFile((File)tmpfile, (OutputStream)packOutputStream);
                                    logger.fine("File " + packFile.getTargetPath() + " added compressed as " + comprFormat.toName() + " (" + packFile.length() + " -> " + packFile.size() + " bytes)");
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(finalStream);
                                    FileUtils.deleteQuietly((File)tmpfile);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((OutputStream)finalStream);
                                FileUtils.deleteQuietly((File)tmpfile);
                                break block31;
                            }
                            long bytesWritten = FileUtils.copyFile((File)file, (OutputStream)packOutputStream);
                            if (bytesWritten != packFile.length()) {
                                throw new IOException("File size mismatch when reading " + file);
                            }
                            logger.fine("File " + packFile.getTargetPath() + " added uncompressed (" + bytesWritten + " bytes)");
                        }
                        storedFiles.put(file, packFile);
                    }
                    pack.addFileSize(packFile.length());
                }
                if (pack.getFileSize() > pack.getSize()) {
                    pack.setSize(pack.getFileSize());
                }
                packOutputStream.flush();
                packOutputStream.close();
                packJar.closeEntry();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)packOutputStream);
                packJar.flush();
                if (this.packSeparateJars()) {
                    packJar.close();
                }
            }
            XMLElementImpl child = new XMLElementImpl("pack", (IXMLElement)root);
            child.setAttribute("name", pack.getName());
            child.setAttribute("size", Long.toString(pack.getSize()));
            child.setAttribute("fileSize", Long.toString(pack.getFileSize()));
            if (pack.getLangPackId() != null) {
                child.setAttribute("id", pack.getLangPackId());
            }
            root.addChild((IXMLElement)child);
            ++packNumber;
        }
        installerJar.putNextEntry(new ZipEntry("resources/packs.info"));
        ObjectOutputStream out = new ObjectOutputStream(installerJar);
        out.writeObject(packs);
        out.flush();
        installerJar.closeEntry();
        for (PackFile pack200PackFile : pack200Files) {
            File tmpfile;
            block28: {
                tmpfile = null;
                ZipFile jar = null;
                try {
                    installerJar.putNextEntry(new ZipEntry("resources/" + pack200PackFile.getStreamResourceName()));
                    tmpfile = File.createTempFile("izpack-compress", ".pack200", FileUtils.getTempDirectory());
                    CountingOutputStream proxyOutputStream = new CountingOutputStream((OutputStream)FileUtils.openOutputStream((File)tmpfile));
                    BufferedOutputStream bufferedStream = IOUtils.buffer((OutputStream)proxyOutputStream);
                    Pack200.Packer packer = this.createPack200Packer(pack200PackFile);
                    jar = new JarFile(pack200PackFile.getFile());
                    packer.pack((JarFile)jar, (OutputStream)bufferedStream);
                    ((OutputStream)bufferedStream).flush();
                    pack200PackFile.setSize(proxyOutputStream.getByteCount());
                    FileUtils.copyFile((File)tmpfile, (OutputStream)installerJar);
                    logger.fine("File " + pack200PackFile.getTargetPath() + " added compressed as Pack 200 (" + pack200PackFile.length() + " -> " + pack200PackFile.size() + " bytes)");
                    if (jar == null) break block28;
                }
                catch (Throwable throwable) {
                    if (jar != null) {
                        jar.close();
                    }
                    installerJar.closeEntry();
                    installerJar.flush();
                    FileUtils.deleteQuietly(tmpfile);
                    throw throwable;
                }
                jar.close();
            }
            installerJar.closeEntry();
            installerJar.flush();
            FileUtils.deleteQuietly((File)tmpfile);
        }
    }

    private Pack200.Packer createPack200Packer(PackFile packFile) {
        Pack200.Packer packer = Pack200.newPacker();
        SortedMap defaultPackerProperties = packer.properties();
        Map localPackerProperties = packFile.getPack200Properties();
        if (localPackerProperties != null) {
            defaultPackerProperties.putAll(localPackerProperties);
        }
        return packer;
    }

    @Override
    public void addConfigurationInformation(IXMLElement data) {
    }
}

