/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.merge;

import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.compiler.merge.PanelMerge;
import com.izforge.izpack.compiler.util.CompilerClassLoader;
import com.izforge.izpack.installer.automation.PanelAutomationHelper;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.util.PanelHelper;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import com.izforge.izpack.merge.resolve.PathResolver;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class CompilerPathResolver
extends PathResolver {
    private static final Logger logger = Logger.getLogger(CompilerPathResolver.class.getName());
    private final CompilerClassLoader loader;
    private final Properties panelDependencies;

    public CompilerPathResolver(MergeableResolver mergeableResolver, CompilerClassLoader loader, Properties panelDependencies) {
        super(mergeableResolver);
        this.loader = loader;
        this.panelDependencies = panelDependencies;
    }

    public PanelMerge getPanelMerge(String className) {
        Class<IzPanel> type = this.loader.loadClass(className, IzPanel.class);
        HashMap<String, List<Mergeable>> mergeableByPackage = new HashMap<String, List<Mergeable>>();
        ArrayList<Mergeable> mergeable = new ArrayList<Mergeable>();
        this.getMergeableByPackage(type, mergeableByPackage);
        Class consoleType = PanelHelper.getConsolePanel((String)className, (ClassLoader)this.loader);
        if (consoleType != null) {
            this.getMergeableByPackage(consoleType, mergeableByPackage);
        } else {
            logger.warning("No console mode helper found for class " + className + ", panel type will be skipped in console mode installation");
        }
        Class automatedType = PanelHelper.getAutomatedPanel((String)className, (ClassLoader)this.loader);
        if (automatedType != null) {
            this.getMergeableByPackage(automatedType, mergeableByPackage);
        } else {
            logger.warning("No automation helper found for class " + className + ", panel type will be skipped in automated installation");
        }
        for (List pkg : mergeableByPackage.values()) {
            mergeable.addAll(pkg);
        }
        return new PanelMerge(type, mergeable);
    }

    public List<Mergeable> getMergeablePackage(Package merge) {
        Enumeration<URL> urls;
        ArrayList<Mergeable> result = new ArrayList<Mergeable>();
        String destination = merge.getName().replaceAll("\\.", "/");
        try {
            urls = ((Object)((Object)this)).getClass().getClassLoader().getResources(destination);
        }
        catch (IOException exception) {
            throw new CompilerException("Failed to locate resources in package: " + merge.getName(), (Throwable)exception);
        }
        MergeableResolver mergeableResolver = this.getMergeableResolver();
        while (urls.hasMoreElements()) {
            URL obtainPackage = urls.nextElement();
            result.add(mergeableResolver.getMergeableFromURLWithDestination(obtainPackage, destination + "/"));
        }
        return result;
    }

    private void getMergeableByPackage(Class type, Map<String, List<Mergeable>> mergeable) {
        String pkg = type.getPackage().getName();
        if (!mergeable.containsKey(pkg)) {
            String dependPackage;
            mergeable.put(pkg, this.getMergeablePackage(type.getPackage()));
            if (this.panelDependencies.containsKey(type.getSimpleName()) && !mergeable.containsKey(dependPackage = (String)this.panelDependencies.get(type.getSimpleName()))) {
                mergeable.put(dependPackage, this.getMergeableFromPackageName(dependPackage));
            }
        }
        for (Class<?> iface : type.getInterfaces()) {
            this.getMergeableByPackage(iface, mergeable);
        }
        Class superClass = type.getSuperclass();
        if (!(superClass == null || superClass.equals(IzPanel.class) || superClass.equals(AbstractConsolePanel.class) || superClass.equals(PanelAutomationHelper.class) || superClass.equals(Object.class))) {
            this.getMergeableByPackage(superClass, mergeable);
        }
    }
}

