/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.compiler.helper;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.compiler.helper.AssertionHelper;
import java.net.MalformedURLException;
import java.net.URL;

public class XmlCompilerHelper {
    private AssertionHelper assertionHelper;

    public XmlCompilerHelper(AssertionHelper assertionHelper) {
        this.assertionHelper = assertionHelper;
    }

    public String requireContent(IXMLElement element) throws CompilerException {
        String content = element.getContent();
        if (content == null || content.length() == 0) {
            this.assertionHelper.parseError(element, "<" + element.getName() + "> requires content");
        }
        return content;
    }

    public URL requireURLContent(IXMLElement element) throws CompilerException {
        URL url = null;
        try {
            url = new URL(this.requireContent(element).replace(" ", "%20"));
        }
        catch (MalformedURLException x) {
            this.assertionHelper.parseError(element, "<" + element.getName() + "> requires valid URL", x);
        }
        return url;
    }

    public IXMLElement requireChildNamed(IXMLElement parent, String name) throws CompilerException {
        IXMLElement child = parent.getFirstChildNamed(name);
        if (child == null) {
            this.assertionHelper.parseError(parent, "<" + parent.getName() + "> requires child <" + name + ">");
        }
        return child;
    }

    public int requireIntAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null || value.length() == 0) {
            this.assertionHelper.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException x) {
            this.assertionHelper.parseError(element, "'" + attribute + "' must be an integer");
            return 0;
        }
    }

    public boolean requireYesNoAttribute(IXMLElement element, String attribute) throws CompilerException {
        return this.validateYesNoAttribute(element, attribute, null);
    }

    public boolean validateYesNoAttribute(IXMLElement element, String attribute, Boolean defaultValue) throws CompilerException {
        if (element != null) {
            String value = element.getAttribute(attribute);
            if (value == null) {
                if (defaultValue == null) {
                    this.assertionHelper.parseError(element, "Undefined value of attribute '" + attribute + "' which is not associated with a default value");
                }
            } else {
                if ("yes".equalsIgnoreCase(value) || Boolean.parseBoolean(value)) {
                    return true;
                }
                if ("no".equalsIgnoreCase(value) || Boolean.FALSE.toString().equalsIgnoreCase(value)) {
                    return false;
                }
                String msg = "Invalid value \"" + value + "\" of attribute '" + attribute + "': Expected (yes|no|true|false)";
                if (defaultValue == null) {
                    this.assertionHelper.parseError(element, msg + " and no default value specified");
                } else {
                    this.assertionHelper.parseWarn(element, msg);
                }
            }
        }
        return defaultValue;
    }

    public String requireAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null) {
            this.assertionHelper.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        return value;
    }

    public long getLong(IXMLElement element, String attribute, long defaultValue) throws CompilerException {
        long result = defaultValue;
        String value = element.getAttribute(attribute);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException exception) {
                this.assertionHelper.parseError(element, "'" + attribute + "' is not a long: " + value);
            }
        }
        return result;
    }
}

