/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.injection;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.google.inject.util.Providers;
import griffon.core.ApplicationEvent;
import griffon.core.Context;
import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonArtifact;
import griffon.core.env.ApplicationPhase;
import griffon.core.injection.Binding;
import griffon.core.injection.InjectorFactory;
import griffon.exceptions.FieldException;
import griffon.exceptions.NewInstanceException;
import griffon.inject.Contextual;
import griffon.util.AnnotationUtils;
import griffon.util.GriffonClassUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.codehaus.griffon.runtime.core.injection.InjectorProvider;
import org.codehaus.griffon.runtime.injection.GuiceInjector;
import org.codehaus.griffon.runtime.injection.InstanceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceInjectorFactory
implements InjectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GuiceInjectorFactory.class);

    @Nonnull
    public GuiceInjector createInjector(@Nonnull GriffonApplication application, @Nonnull Iterable<Binding<?>> bindings) {
        Objects.requireNonNull(application, "Argument 'application' must not be null");
        Objects.requireNonNull(bindings, "Argument 'bindings' must not be null");
        InjectorProvider injectorProvider = new InjectorProvider();
        GuiceInjector injector = this.createModules(application, injectorProvider, bindings);
        injectorProvider.setInjector((griffon.core.injection.Injector)injector);
        return injector;
    }

    private GuiceInjector createModules(@Nonnull GriffonApplication application, final @Nonnull InjectorProvider injectorProvider, @Nonnull Iterable<Binding<?>> bindings) {
        final InjectionListener injectionListener = injectee -> application.getEventRouter().publishEvent(ApplicationEvent.NEW_INSTANCE.getName(), Arrays.asList(injectee.getClass(), injectee));
        final InjectionListener postConstructorInjectorListener = injectee -> {
            this.resolveContextualInjections(injectee, application);
            this.resolveConfigurationInjections(injectee, application);
            GriffonClassUtils.invokeAnnotatedMethod((Object)injectee, PostConstruct.class);
        };
        final InstanceTracker instanceTracker = new InstanceTracker();
        AbstractModule injectorModule = new AbstractModule(){

            protected void configure() {
                this.bind(griffon.core.injection.Injector.class).toProvider(Providers.guicify((Provider)injectorProvider)).in(Singleton.class);
                this.bindListener((Matcher)new AbstractMatcher<TypeLiteral<?>>(){

                    public boolean matches(TypeLiteral<?> typeLiteral) {
                        return GriffonArtifact.class.isAssignableFrom(typeLiteral.getRawType());
                    }
                }, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        if (GriffonArtifact.class.isAssignableFrom(type.getRawType())) {
                            TypeEncounter<I> artifactEncounter = encounter;
                            artifactEncounter.register(injectionListener);
                        }
                    }
                });
                this.bindListener(Matchers.any(), new TypeListener(){

                    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
                        encounter.register(postConstructorInjectorListener);
                    }
                });
                this.bindListener(Matchers.any(), new ProvisionListener[]{new ProvisionListener(){

                    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
                        instanceTracker.track(provision.getBinding(), provision.provision());
                    }
                }});
            }
        };
        ArrayList<1> modules = new ArrayList<1>();
        modules.add(injectorModule);
        modules.add(GuiceInjector.moduleFromBindings(bindings));
        ArrayList<Module> loadedModules = new ArrayList<Module>();
        ServiceLoader<Module> moduleLoader = ServiceLoader.load(Module.class, this.getClass().getClassLoader());
        for (Module module : moduleLoader) {
            LOG.trace("Adding module {}", (Object)module);
            loadedModules.add(module);
        }
        Map sortedModules = AnnotationUtils.sortByDependencies(loadedModules, (String)"Module", (String)"module");
        modules.addAll(sortedModules.values());
        Injector injector = Guice.createInjector(modules);
        instanceTracker.setInjector(injector);
        return new GuiceInjector(instanceTracker);
    }

    protected void resolveContextualInjections(@Nonnull Object injectee, @Nonnull GriffonApplication application) {
        if (application.getPhase() == ApplicationPhase.INITIALIZE || injectee instanceof GriffonArtifact) {
            return;
        }
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        for (Field field : GriffonClassUtils.getAllDeclaredFields(injectee.getClass())) {
            fields.put(field.getName(), field);
        }
        LinkedHashMap<String, InjectionPoint> injectionPoints = new LinkedHashMap<String, InjectionPoint>();
        for (PropertyDescriptor descriptor : GriffonClassUtils.getPropertyDescriptors(injectee.getClass())) {
            Method method = descriptor.getWriteMethod();
            if (method == null || this.isInjectable(method)) continue;
            boolean nullable = method.getAnnotation(Nonnull.class) == null && AnnotationUtils.findAnnotation((Annotation[])AnnotationUtils.annotationsOfMethodParameter((Method)method, (int)0), Nonnull.class) == null;
            InjectionPoint.Type type = this.resolveType(method);
            Field field = (Field)fields.get(descriptor.getName());
            if (field != null && type == InjectionPoint.Type.OTHER) {
                type = this.resolveType(field);
                nullable = field.getAnnotation(Nonnull.class) == null;
            }
            injectionPoints.put(descriptor.getName(), new MethodInjectionPoint(descriptor.getName(), nullable, method, type));
        }
        for (Field field : GriffonClassUtils.getAllDeclaredFields(injectee.getClass())) {
            if (Modifier.isStatic(field.getModifiers()) || this.isInjectable(field) || injectionPoints.containsKey(field.getName())) continue;
            boolean nullable = field.getAnnotation(Nonnull.class) == null;
            InjectionPoint.Type type = this.resolveType(field);
            injectionPoints.put(field.getName(), new FieldInjectionPoint(field.getName(), nullable, field, type));
        }
        for (InjectionPoint ip : injectionPoints.values()) {
            ip.apply(application.getContext(), injectee);
        }
    }

    @Nonnull
    protected InjectionPoint.Type resolveType(@Nonnull AnnotatedElement element) {
        if (this.isContextual(element)) {
            return InjectionPoint.Type.CONTEXTUAL;
        }
        return InjectionPoint.Type.OTHER;
    }

    protected boolean isContextual(AnnotatedElement element) {
        return element != null && element.getAnnotation(Contextual.class) != null;
    }

    protected boolean isInjectable(AnnotatedElement element) {
        return element != null && element.getAnnotation(Inject.class) != null;
    }

    protected void resolveConfigurationInjections(@Nonnull Object injectee, @Nonnull GriffonApplication application) {
        if (application.getPhase() == ApplicationPhase.INITIALIZE || injectee instanceof GriffonArtifact) {
            return;
        }
        application.getConfigurationManager().injectConfiguration(injectee);
    }

    protected static class MethodInjectionPoint
    extends InjectionPoint {
        protected final Method method;

        protected MethodInjectionPoint(String name, boolean nullable, Method method, InjectionPoint.Type type) {
            super(name, nullable, type);
            this.method = method;
        }

        @Override
        protected void apply(@Nonnull Context context, @Nonnull Object instance) {
            if (this.type == InjectionPoint.Type.CONTEXTUAL) {
                Object[] keys = AnnotationUtils.namesFor((Method)this.method);
                Object argValue = null;
                for (String string : keys) {
                    if (!context.containsKey(string)) continue;
                    argValue = context.get(string);
                    break;
                }
                try {
                    if (argValue == null) {
                        if (!this.nullable) {
                            throw new IllegalStateException("Could not find an instance of type " + this.method.getParameterTypes()[0].getName() + " under keys '" + Arrays.toString(keys) + "' in the application context to be injected on property '" + this.name + "' in " + instance.getClass().getName() + "). Property does not accept null values.");
                        }
                        return;
                    }
                    this.method.invoke(instance, argValue);
                }
                catch (IllegalAccessException | IllegalStateException | InvocationTargetException e) {
                    throw new NewInstanceException(instance.getClass(), (Throwable)e);
                }
            }
        }
    }

    protected static class FieldInjectionPoint
    extends InjectionPoint {
        protected final Field field;

        protected FieldInjectionPoint(String name, boolean nullable, Field field, InjectionPoint.Type type) {
            super(name, nullable, type);
            this.field = field;
        }

        @Override
        protected void apply(@Nonnull Context context, @Nonnull Object instance) {
            if (this.type == InjectionPoint.Type.CONTEXTUAL) {
                Object[] keys = AnnotationUtils.namesFor((Field)this.field);
                Object argValue = null;
                for (String string : keys) {
                    if (!context.containsKey(string)) continue;
                    argValue = context.get(string);
                    break;
                }
                try {
                    if (argValue == null) {
                        if (!this.nullable) {
                            throw new IllegalStateException("Could not find an instance of type " + this.field.getType().getName() + " under keys '" + Arrays.toString(keys) + "' in the application context to be injected on field '" + this.field.getName() + "' in " + instance.getClass().getName() + ". Field does not accept null values.");
                        }
                        return;
                    }
                    GriffonClassUtils.setFieldValue((Object)instance, (String)this.name, argValue);
                }
                catch (FieldException | IllegalStateException e) {
                    throw new NewInstanceException(instance.getClass(), e);
                }
            }
        }
    }

    protected static abstract class InjectionPoint {
        protected final String name;
        protected final boolean nullable;
        protected final Type type;

        protected InjectionPoint(String name, boolean nullable, Type type) {
            this.name = name;
            this.nullable = nullable;
            this.type = type;
        }

        protected abstract void apply(@Nonnull Context var1, @Nonnull Object var2);

        protected static enum Type {
            CONTEXTUAL,
            OTHER;

        }
    }
}

