/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy.util;

import griffon.core.resources.ResourceHandler;
import griffon.inject.Evicts;
import griffon.util.ConfigReader;
import griffon.util.GriffonNameUtils;
import griffon.util.Instantiator;
import griffon.util.ResourceBundleReader;
import groovy.lang.Script;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.griffon.runtime.groovy.util.GroovyScriptResourceBundle;
import org.codehaus.griffon.runtime.util.ClassResourceBundleLoader;

@Evicts(value="class")
@Named(value="groovy")
public class GroovyScriptResourceBundleLoader
extends ClassResourceBundleLoader {
    protected static final String GROOVY_SUFFIX = ".groovy";
    private final ConfigReader configReader;

    @Inject
    public GroovyScriptResourceBundleLoader(@Nonnull Instantiator instantiator, @Nonnull ResourceHandler resourceHandler, @Nonnull ResourceBundleReader resourceBundleReader, @Nonnull ConfigReader configReader) {
        super(instantiator, resourceHandler, resourceBundleReader);
        this.configReader = Objects.requireNonNull(configReader, "Argument 'configReader' must not be null");
    }

    @Nonnull
    public Collection<ResourceBundle> load(@Nonnull String name) {
        GriffonNameUtils.requireNonBlank((String)name, (String)"Argument 'fileName' must not be blank");
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        URL resource = this.getResourceAsURL(name, GROOVY_SUFFIX);
        if (null != resource) {
            bundles.add(new GroovyScriptResourceBundle(this.configReader, resource));
            return bundles;
        }
        resource = this.getResourceAsURL(name, ".class");
        if (null != resource) {
            String className = name.replace('/', '.');
            try {
                Class klass = this.loadClass(className);
                if (Script.class.isAssignableFrom(klass)) {
                    bundles.add(new GroovyScriptResourceBundle(this.configReader, klass));
                    return bundles;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.load(name);
    }
}

