/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy.mvc;

import griffon.core.ApplicationClassLoader;
import griffon.core.GriffonApplication;
import griffon.core.GriffonExceptionHandler;
import griffon.core.mvc.MVCGroup;
import griffon.util.AnnotationUtils;
import griffon.util.BuilderCustomizer;
import griffon.util.CompositeBuilder;
import griffon.util.Instantiator;
import groovy.util.FactoryBuilderSupport;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.mvc.DefaultMVCGroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyAwareMVCGroupManager
extends DefaultMVCGroupManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMVCGroupManager.class);
    private static final String BUILDER_CUSTOMIZER = "BuilderCustomizer";

    @Inject
    public GroovyAwareMVCGroupManager(@Nonnull GriffonApplication application, @Nonnull ApplicationClassLoader applicationClassLoader, @Nonnull Instantiator instantiator) {
        super(application, applicationClassLoader, instantiator);
    }

    @Nonnull
    protected Map<String, Object> instantiateMembers(@Nonnull Map<String, DefaultMVCGroupManager.ClassHolder> classMap, @Nonnull Map<String, Object> args) {
        Map map = super.instantiateMembers(classMap, args);
        FactoryBuilderSupport builder = this.createBuilder(this.getApplication());
        map.put("builder", builder);
        return map;
    }

    @Nonnull
    protected FactoryBuilderSupport createBuilder(@Nonnull GriffonApplication application) {
        Collection<BuilderCustomizer> customizers = this.resolveBuilderCustomizers(application);
        return new CompositeBuilder(customizers.toArray(new BuilderCustomizer[customizers.size()]));
    }

    protected void adjustMvcArguments(@Nonnull MVCGroup group, @Nonnull Map<String, Object> args) {
        super.adjustMvcArguments(group, args);
        FactoryBuilderSupport builder = (FactoryBuilderSupport)group.getMember("builder");
        args.put("builder", builder);
        for (Map.Entry<String, Object> variable : args.entrySet()) {
            builder.setVariable(variable.getKey(), variable.getValue());
        }
    }

    protected void initializeMembers(@Nonnull MVCGroup group, @Nonnull Map<String, Object> args) {
        FactoryBuilderSupport builder = (FactoryBuilderSupport)group.getMember("builder");
        builder.setVariable("_CURRENT_MVCGROUP_", (Object)group);
        super.initializeMembers(group, args);
    }

    protected void destroyMembers(@Nonnull MVCGroup group, boolean fireDestructionEvents) {
        super.destroyMembers(group, fireDestructionEvents);
        try {
            FactoryBuilderSupport builder = (FactoryBuilderSupport)group.getMember("builder");
            if (builder != null) {
                builder.dispose();
                builder.getVariables().clear();
            }
        }
        catch (Exception e) {
            LOG.error("Application encountered an error while destroying group '" + group.getMvcId() + "'", GriffonExceptionHandler.sanitize((Throwable)e));
        }
    }

    @Nonnull
    protected Collection<BuilderCustomizer> resolveBuilderCustomizers(@Nonnull GriffonApplication application) {
        Collection customizerInstances = application.getInjector().getInstances(BuilderCustomizer.class);
        return AnnotationUtils.sortByDependencies((Collection)customizerInstances, (String)BUILDER_CUSTOMIZER, (String)"customizer").values();
    }
}

