/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import groovy.util.IndentPrinter;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovy.util.slurpersupport.Node;
import groovy.util.slurpersupport.NodeChild;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Xml2Groovy {
    private static final Xml2Groovy INSTANCE = new Xml2Groovy();

    public static Xml2Groovy getInstance() {
        return INSTANCE;
    }

    private Xml2Groovy() {
    }

    public String parse(File file) {
        try {
            return this.translate(this.newXmlSlurper().parse(file));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String parse(InputSource source) {
        try {
            return this.translate(this.newXmlSlurper().parse(source));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String parse(InputStream stream) {
        try {
            return this.translate(this.newXmlSlurper().parse(stream));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String parse(Reader reader) {
        try {
            return this.translate(this.newXmlSlurper().parse(reader));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String parse(String uri) {
        try {
            return this.translate(this.newXmlSlurper().parse(uri));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String parse(GPathResult root) {
        return this.translate(root);
    }

    public String parseText(String text) {
        try {
            return this.translate(this.newXmlSlurper().parseText(text));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private XmlSlurper newXmlSlurper() {
        try {
            return new XmlSlurper();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String translate(GPathResult root) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IndentPrinter printer = this.createIndentPrinter(baos);
        this.walkXml(printer, (NodeChild)root);
        printer.flush();
        return baos.toString();
    }

    private IndentPrinter createIndentPrinter(OutputStream os) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(os));
        return new IndentPrinter((Writer)pw, "    ");
    }

    private void walkXml(IndentPrinter printer, NodeChild node) {
        printer.printIndent();
        printer.print(node.name());
        if (!node.attributes().isEmpty()) {
            printer.print("(");
            ArrayList<String> attrs = new ArrayList<String>();
            Iterator iterator = node.attributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                attrs.add(entry.getKey() + ": " + entry.getValue());
            }
            printer.print(DefaultGroovyMethods.join(attrs, (String)", "));
            printer.print(")");
        }
        if (node.children().size() > 0) {
            printer.println(" {");
            printer.incrementIndent();
            Iterator iter = node.childNodes();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (child instanceof NodeChild) {
                    this.walkXml(printer, (NodeChild)child);
                    continue;
                }
                if (!(child instanceof Node)) continue;
                this.walkXml(printer, (Node)child);
            }
            printer.decrementIndent();
            printer.printIndent();
            printer.println("}");
        } else if (!node.attributes().isEmpty()) {
            printer.println("");
        } else {
            printer.println("()");
        }
    }

    private void walkXml(IndentPrinter printer, Node node) {
        printer.printIndent();
        printer.print(node.name());
        if (!node.attributes().isEmpty()) {
            printer.print("(");
            ArrayList<String> attrs = new ArrayList<String>();
            Iterator iterator = node.attributes().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                attrs.add(entry.getKey() + ": " + entry.getValue());
            }
            printer.print(DefaultGroovyMethods.join(attrs, (String)", "));
            printer.print(")");
        }
        if (!node.children().isEmpty()) {
            printer.println(" {");
            printer.incrementIndent();
            Iterator iter = node.childNodes();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (child instanceof NodeChild) {
                    this.walkXml(printer, (NodeChild)child);
                    continue;
                }
                if (!(child instanceof Node)) continue;
                this.walkXml(printer, (Node)child);
            }
            printer.decrementIndent();
            printer.printIndent();
            printer.println("}");
        } else if (!node.attributes().isEmpty()) {
            printer.println("");
        } else {
            printer.println("()");
        }
    }
}

