/*
 * Decompiled with CFR 0.152.
 */
package griffon.builder.core;

import griffon.builder.core.factory.MetaComponentFactory;
import griffon.core.threading.UIThreadManager;
import griffon.util.TypeUtils;
import groovy.lang.Closure;
import groovy.util.Factory;
import groovy.util.FactoryBuilderSupport;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.griffon.runtime.groovy.view.AbstractBuilderCustomizer;
import org.codehaus.groovy.runtime.MethodClosure;

@Named(value="core")
public class CoreBuilderCustomizer
extends AbstractBuilderCustomizer {
    private static final String KEY_ROOT_NODE_NAME = "ROOT_NODE_NAME";
    private static final String MVC_ID = "mvcId";
    private static final String ROOT_NODE_IDENTIFIED_BY_ATTRIBUTE = "rootNodeIdentifiedByAttribute";
    @Inject
    private UIThreadManager uiThreadManager;

    public CoreBuilderCustomizer() {
        LinkedHashMap<String, Factory> factories = new LinkedHashMap<String, Factory>();
        factories.put("metaComponent", (Factory)new MetaComponentFactory());
        this.setFactories(factories);
    }

    @PostConstruct
    private void setup() {
        LinkedHashMap<String, Closure> methods = new LinkedHashMap<String, Closure>();
        methods.put("runInsideUISync", (Closure)new MethodClosure((Object)this.uiThreadManager, "runInsideUISync"));
        methods.put("runInsideUIAsync", (Closure)new MethodClosure((Object)this.uiThreadManager, "runInsideUIAsync"));
        methods.put("runOutsideUI", (Closure)new MethodClosure((Object)this.uiThreadManager, "runOutsideUI"));
        methods.put("runOutsideUIAsync", (Closure)new MethodClosure((Object)this.uiThreadManager, "runOutsideUIAsync"));
        methods.put("runFuture", (Closure)new MethodClosure((Object)this.uiThreadManager, "runFuture"));
        methods.put("isUIThread", (Closure)new MethodClosure((Object)this.uiThreadManager, "isUIThread"));
        this.setMethods(methods);
    }

    @Override
    @Nonnull
    public List<Closure> getAttributeDelegates() {
        return Collections.singletonList(new MethodClosure((Object)this, "rootAttributeDelegate"));
    }

    @Override
    @Nonnull
    public List<Closure> getPreInstantiateDelegates() {
        return Collections.singletonList(new MethodClosure((Object)this, "rootNodePreInstantiateDelegate"));
    }

    @Override
    @Nonnull
    public List<Closure> getPostNodeCompletionDelegates() {
        return Collections.singletonList(new MethodClosure((Object)this, "rootNodePostNodeCompletionDelegate"));
    }

    protected void rootAttributeDelegate(FactoryBuilderSupport builder, Object node, Map attributes) {
        Object isRootNode = attributes.remove("rootNode");
        if (isRootNode != null && TypeUtils.castToBoolean(isRootNode)) {
            String mvcId = String.valueOf(builder.getVariable(MVC_ID));
            builder.getVariables().put(ROOT_NODE_IDENTIFIED_BY_ATTRIBUTE, true);
            builder.getVariables().put(mvcId + "-rootNode", node);
        }
    }

    protected void rootNodePreInstantiateDelegate(FactoryBuilderSupport builder, Map attributes, Object value) {
        String name = String.valueOf(builder.getContext().get("_CURRENT_NAME_"));
        if (!builder.hasVariable(KEY_ROOT_NODE_NAME)) {
            builder.setVariable(KEY_ROOT_NODE_NAME, (Object)name);
        }
    }

    protected void rootNodePostNodeCompletionDelegate(FactoryBuilderSupport builder, Object parent, Object node) {
        Object hasRootNode = builder.getVariables().get(ROOT_NODE_IDENTIFIED_BY_ATTRIBUTE);
        if (hasRootNode != null && TypeUtils.castToBoolean(hasRootNode)) {
            return;
        }
        String name = String.valueOf(builder.getContext().get("_CURRENT_NAME_"));
        if (builder.getVariable(KEY_ROOT_NODE_NAME).equals(name) && builder.hasVariable(MVC_ID)) {
            String mvcId = String.valueOf(builder.getVariable(MVC_ID));
            builder.getVariables().put(mvcId + "-rootNode", node);
        }
    }
}

