/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.gmavenplus.mojo.AbstractGroovyMojo;

public abstract class AbstractGroovySourcesMojo
extends AbstractGroovyMojo {
    protected static final String MAIN = "main";
    protected static final String TEST = "test";

    protected SortedSet<File> getFiles(FileSet[] fromSources, boolean includeJavaSources) {
        TreeSet<File> files = new TreeSet<File>();
        FileSetManager fileSetManager = new FileSetManager(this.getLog());
        for (FileSet fileSet : this.getFilesets(fromSources, includeJavaSources)) {
            for (String include : fileSetManager.getIncludedFiles(fileSet)) {
                files.add(new File(fileSet.getDirectory(), include));
            }
        }
        return files;
    }

    protected SortedSet<File> getTestFiles(FileSet[] fromSources, boolean includeJavaSources) {
        TreeSet<File> files = new TreeSet<File>();
        FileSetManager fileSetManager = new FileSetManager(this.getLog());
        for (FileSet fileSet : this.getTestFilesets(fromSources, includeJavaSources)) {
            for (String include : fileSetManager.getIncludedFiles(fileSet)) {
                files.add(new File(fileSet.getDirectory(), include));
            }
        }
        return files;
    }

    protected FileSet[] getFilesets(FileSet[] fromSources, boolean includeJavaSources) {
        FileSet[] result;
        FileSet[] groovyFileSets;
        if (fromSources != null) {
            groovyFileSets = fromSources;
        } else {
            FileSet groovyFileSet = new FileSet();
            String groovyDirectory = "src" + File.separator + MAIN + File.separator + "groovy";
            groovyFileSet.setDirectory(this.project.getBasedir() + File.separator + (String)groovyDirectory);
            groovyFileSet.setIncludes(Collections.singletonList(GROOVY_SOURCES_PATTERN));
            groovyFileSets = new FileSet[]{groovyFileSet};
        }
        if (includeJavaSources) {
            ArrayList<FileSet> javaFileSets = new ArrayList<FileSet>();
            for (Object sourceRoot : this.project.getCompileSourceRoots()) {
                FileSet javaFileSet = new FileSet();
                javaFileSet.setDirectory((String)sourceRoot);
                javaFileSet.setIncludes(Collections.singletonList(JAVA_SOURCES_PATTERN));
                javaFileSets.add(javaFileSet);
            }
            FileSet[] javaFileSetsArr = javaFileSets.toArray(new FileSet[0]);
            result = Arrays.copyOf(groovyFileSets, groovyFileSets.length + javaFileSetsArr.length);
            System.arraycopy(javaFileSetsArr, 0, result, groovyFileSets.length, javaFileSetsArr.length);
        } else {
            result = groovyFileSets;
        }
        return result;
    }

    protected FileSet[] getTestFilesets(FileSet[] fromSources, boolean includeJavaSources) {
        FileSet[] result;
        FileSet[] groovyFileSets;
        if (fromSources != null) {
            groovyFileSets = fromSources;
        } else {
            FileSet groovyFileSet = new FileSet();
            String groovyDirectory = "src" + File.separator + TEST + File.separator + "groovy";
            groovyFileSet.setDirectory(this.project.getBasedir() + File.separator + (String)groovyDirectory);
            groovyFileSet.setIncludes(Collections.singletonList(GROOVY_SOURCES_PATTERN));
            groovyFileSets = new FileSet[]{groovyFileSet};
        }
        if (includeJavaSources) {
            ArrayList<FileSet> javaFileSets = new ArrayList<FileSet>();
            for (Object sourceRoot : this.project.getTestCompileSourceRoots()) {
                FileSet javaFileSet = new FileSet();
                javaFileSet.setDirectory((String)sourceRoot);
                javaFileSet.setIncludes(Collections.singletonList(JAVA_SOURCES_PATTERN));
                javaFileSets.add(javaFileSet);
            }
            FileSet[] javaFileSetsArr = javaFileSets.toArray(new FileSet[0]);
            result = Arrays.copyOf(groovyFileSets, groovyFileSets.length + javaFileSetsArr.length);
            System.arraycopy(javaFileSetsArr, 0, result, groovyFileSets.length, javaFileSetsArr.length);
        } else {
            result = groovyFileSets;
        }
        return result;
    }
}

