/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.gmavenplus.groovyworkarounds.DotGroovyFile;
import org.codehaus.gmavenplus.model.IncludeClasspath;
import org.codehaus.gmavenplus.model.internal.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovyStubSourcesMojo;
import org.codehaus.gmavenplus.util.FileUtils;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public abstract class AbstractGenerateStubsMojo
extends AbstractGroovyStubSourcesMojo {
    protected static final Version GROOVY_3_0_6 = new Version(3, 0, 6);
    protected static final Version GROOVY_3_0_3 = new Version(3, 0, 3);
    protected static final Version GROOVY_3_0_0_BETA2 = new Version(3, 0, 0, "beta-2");
    protected static final Version GROOVY_3_0_0_BETA1 = new Version(3, 0, 0, "beta-1");
    protected static final Version GROOVY_3_0_0_ALPHA4 = new Version(3, 0, 0, "alpha-4");
    protected static final Version GROOVY_3_0_0_ALPHA2 = new Version(3, 0, 0, "alpha-2");
    protected static final Version GROOVY_3_0_0_ALPHA1 = new Version(3, 0, 0, "alpha-1");
    protected static final Version GROOVY_2_6_0_ALPHA4 = new Version(2, 6, 0, "alpha-4");
    protected static final Version GROOVY_2_6_0_ALPHA1 = new Version(2, 6, 0, "alpha-1");
    protected static final Version GROOVY_2_5_7 = new Version(2, 5, 7);
    protected static final Version GROOVY_2_5_3 = new Version(2, 5, 3);
    protected static final Version GROOVY_2_3_3 = new Version(2, 3, 3);
    protected static final Version GROOVY_2_1_3 = new Version(2, 1, 3);
    protected static final Version GROOVY_1_9_0_BETA1 = new Version(1, 9, 0, "beta-1");
    protected static final Version GROOVY_1_9_0_BETA3 = new Version(1, 9, 0, "beta-3");
    protected static final Version GROOVY_1_8_2 = new Version(1, 8, 2);
    protected static final Version GROOVY_1_8_3 = new Version(1, 8, 3);
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(property="maven.compiler.target", defaultValue="1.8")
    protected String targetBytecode;
    @Parameter(property="skipBytecodeCheck", defaultValue="false")
    protected boolean skipBytecodeCheck;
    @Parameter(defaultValue="false")
    protected boolean debug;
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="1")
    protected int warningLevel;
    @Parameter(defaultValue="0")
    protected int tolerance;
    @Parameter(defaultValue="PROJECT_ONLY")
    protected IncludeClasspath includeClasspath;

    protected synchronized void doStubGeneration(Set<File> stubSources, List<?> classpath, File outputDirectory) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, MalformedURLException {
        if (stubSources == null || stubSources.isEmpty()) {
            this.getLog().info((CharSequence)"No sources specified for stub generation. Skipping.");
            return;
        }
        this.setupClassWrangler(classpath, this.includeClasspath);
        this.logPluginClasspath();
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        if (!this.groovyVersionSupportsAction() || this.skipBytecodeCheck) {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support stub generation. The minimum version of Groovy required is " + this.minGroovyVersion + ". Skipping stub generation."));
            return;
        }
        this.verifyGroovyVersionSupportsTargetBytecode();
        Class<?> compilerConfigurationClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilerConfiguration");
        Class<?> javaStubCompilationUnitClass = this.classWrangler.getClass("org.codehaus.groovy.tools.javac.JavaStubCompilationUnit");
        Class<?> groovyClassLoaderClass = this.classWrangler.getClass("groovy.lang.GroovyClassLoader");
        Object compilerConfiguration = this.setupCompilerConfiguration(outputDirectory, compilerConfigurationClass);
        Object groovyClassLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class, compilerConfigurationClass), this.classWrangler.getClassLoader(), compilerConfiguration);
        Object javaStubCompilationUnit = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(javaStubCompilationUnitClass, compilerConfigurationClass, groovyClassLoaderClass, File.class), compilerConfiguration, groovyClassLoader, outputDirectory);
        this.addGroovySources(stubSources, compilerConfigurationClass, javaStubCompilationUnitClass, compilerConfiguration, javaStubCompilationUnit);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(javaStubCompilationUnitClass, "compile", new Class[0]), javaStubCompilationUnit, new Object[0]);
    }

    protected Object setupCompilerConfiguration(File outputDirectory, Class<?> compilerConfigurationClass) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setDebug", Boolean.TYPE), compilerConfiguration, this.debug);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setVerbose", Boolean.TYPE), compilerConfiguration, this.verbose);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setWarningLevel", Integer.TYPE), compilerConfiguration, this.warningLevel);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTolerance", Integer.TYPE), compilerConfiguration, this.tolerance);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetBytecode", String.class), compilerConfiguration, this.targetBytecode);
        if (this.sourceEncoding != null) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, this.sourceEncoding);
        }
        HashMap<String, Comparable<File>> options = new HashMap<String, Comparable<File>>();
        options.put("stubDir", outputDirectory);
        options.put("keepStubs", Boolean.TRUE);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setJointCompilationOptions", Map.class), compilerConfiguration, options);
        return compilerConfiguration;
    }

    protected void addGroovySources(Set<File> stubSources, Class<?> compilerConfigurationClass, Class<?> javaStubCompilationUnitClass, Object compilerConfiguration, Object javaStubCompilationUnit) throws InvocationTargetException, IllegalAccessException {
        HashSet<String> scriptExtensions = new HashSet<String>();
        for (File stubSource : stubSources) {
            scriptExtensions.add(FileUtils.getFileExtension(stubSource));
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Detected Groovy file extensions: " + scriptExtensions + "."));
        }
        if (this.supportsSettingExtensions()) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setScriptExtensions", Set.class), compilerConfiguration, scriptExtensions);
        }
        this.getLog().debug((CharSequence)"Adding Groovy to generate stubs for:");
        Method addSource = ReflectionUtils.findMethod(javaStubCompilationUnitClass, "addSource", File.class);
        for (File stubSource : stubSources) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("    " + stubSource));
            }
            if (this.supportsSettingExtensions()) {
                ReflectionUtils.invokeMethod(addSource, javaStubCompilationUnit, stubSource);
                continue;
            }
            DotGroovyFile dotGroovyFile = new DotGroovyFile(stubSource).setScriptExtensions(scriptExtensions);
            ReflectionUtils.invokeMethod(addSource, javaStubCompilationUnit, dotGroovyFile);
        }
    }

    protected boolean supportsSettingExtensions() {
        return this.groovyAtLeast(GROOVY_1_8_3) && (this.groovyOlderThan(GROOVY_1_9_0_BETA1) || this.groovyNewerThan(GROOVY_1_9_0_BETA3));
    }

    protected void logGeneratedStubs(File outputDirectory) {
        Set<File> stubs = this.getStubs(outputDirectory);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("Generated " + stubs.size() + " stub" + (stubs.size() != 1 ? "s" : "") + "."));
        }
    }

    protected void resetStubModifiedDates(Set<File> stubs) {
        for (File stub : stubs) {
            boolean success = stub.setLastModified(0L);
            if (success || !this.getLog().isWarnEnabled()) continue;
            this.getLog().warn((CharSequence)("Unable to set modified time on stub " + stub.getAbsolutePath() + "."));
        }
    }

    protected void verifyGroovyVersionSupportsTargetBytecode() {
        if ("16".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_3_0_6)) {
                throw new IllegalArgumentException("Target bytecode 16 requires Groovy " + GROOVY_3_0_6 + " or newer.");
            }
        } else if ("15".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_3_0_3)) {
                throw new IllegalArgumentException("Target bytecode 15 requires Groovy " + GROOVY_3_0_3 + " or newer.");
            }
        } else if ("14".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_3_0_0_BETA2)) {
                throw new IllegalArgumentException("Target bytecode 14 requires Groovy " + GROOVY_3_0_0_BETA2 + " or newer.");
            }
        } else if ("13".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_5_7) || this.groovyAtLeast(GROOVY_2_6_0_ALPHA1) && this.groovyOlderThan(GROOVY_3_0_0_BETA1)) {
                throw new IllegalArgumentException("Target bytecode 13 requires Groovy " + GROOVY_2_5_7 + "/" + GROOVY_3_0_0_BETA1 + " or newer. No 2.6 version is supported.");
            }
        } else if ("12".equals(this.targetBytecode) || "11".equals(this.targetBytecode) || "10".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_5_3) || this.groovyAtLeast(GROOVY_2_6_0_ALPHA1) && this.groovyOlderThan(GROOVY_3_0_0_ALPHA4)) {
                throw new IllegalArgumentException("Target bytecode 10, 11, or 12 requires Groovy " + GROOVY_2_5_3 + "/" + GROOVY_3_0_0_ALPHA4 + " or newer. No 2.6 version is supported.");
            }
        } else if ("9".equals(this.targetBytecode)) {
            if (!this.isGroovyIndy() && (this.groovyOlderThan(GROOVY_2_5_3) || this.groovyAtLeast(GROOVY_2_6_0_ALPHA1) && this.groovyOlderThan(GROOVY_2_6_0_ALPHA4) || this.groovyAtLeast(GROOVY_3_0_0_ALPHA1) && this.groovyOlderThan(GROOVY_3_0_0_ALPHA2))) {
                throw new IllegalArgumentException("Target bytecode 9 requires Groovy " + GROOVY_2_5_3 + "/" + GROOVY_2_6_0_ALPHA4 + "/" + GROOVY_3_0_0_ALPHA2 + " or newer.");
            }
            if (this.isGroovyIndy() && (this.groovyOlderThan(GROOVY_2_5_3) || this.groovyAtLeast(GROOVY_2_6_0_ALPHA1) && this.groovyOlderThan(GROOVY_3_0_0_ALPHA4))) {
                throw new IllegalArgumentException("Target bytecode 9 with invokedynamic requires Groovy " + GROOVY_2_5_3 + "/" + GROOVY_3_0_0_ALPHA4 + " or newer. No 2.6 version is supported.");
            }
        } else if ("1.8".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_3_3)) {
                throw new IllegalArgumentException("Target bytecode 1.8 requires Groovy " + GROOVY_2_3_3 + " or newer.");
            }
        } else if ("1.7".equals(this.targetBytecode) || "1.6".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_1_3)) {
                throw new IllegalArgumentException("Target bytecode 1.6 and 1.7 require Groovy " + GROOVY_2_1_3 + " or newer.");
            }
        } else if (!"1.5".equals(this.targetBytecode) && !"1.4".equals(this.targetBytecode)) {
            throw new IllegalArgumentException("Unrecognized target bytecode: '" + this.targetBytecode + "'.");
        }
    }
}

