/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.gmaven.plugin.util.Maps2;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=PropertiesBuilder.class, instantiationStrategy="per-lookup")
public class PropertiesBuilder {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MavenProject project;
    private MavenSession session;
    private Map<String, String> properties;
    private Map<String, String> defaults;

    public PropertiesBuilder setProject(@Nullable MavenProject project) {
        this.project = project;
        return this;
    }

    public PropertiesBuilder setSession(@Nullable MavenSession session) {
        this.session = session;
        return this;
    }

    public PropertiesBuilder setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public PropertiesBuilder setDefaults(@Nullable Map<String, String> defaults) {
        this.defaults = defaults;
        return this;
    }

    public Map<String, String> build() {
        Map<String, String> props = new HashMap<String, String>();
        if (this.defaults != null) {
            props.putAll(this.defaults);
        }
        if (this.project != null) {
            props.putAll(Maps2.fromProperties(this.project.getProperties()));
        }
        if (this.session != null) {
            props.putAll(Maps2.fromProperties(this.session.getSystemProperties()));
            props.putAll(Maps2.fromProperties(this.session.getUserProperties()));
        }
        if (this.properties != null) {
            props.putAll(this.properties);
        }
        props = this.resolve(props);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Properties:");
            ArrayList<String> keys = new ArrayList<String>(props.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                this.log.trace("  {}={}", (Object)key, (Object)props.get(key));
            }
        }
        return props;
    }

    private Map<String, String> resolve(Map<String, String> source) {
        HashMap<String, String> result = new HashMap<String, String>(source.size());
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.addValueSource((ValueSource)new MapBasedValueSource(source));
        for (Map.Entry<String, String> entry : source.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) {
                this.log.warn("Ignoring null property: {}", (Object)key);
                continue;
            }
            if (value.contains("${")) {
                try {
                    value = interpolator.interpolate(value);
                    this.log.trace("Resolved: {} -> '{}'", (Object)key, (Object)value);
                }
                catch (InterpolationException e) {
                    this.log.warn("Failed to interpolate: {}, using original value: {}", (Object)key, (Object)value);
                }
            }
            result.put(key, value);
        }
        return result;
    }
}

