/*
 * Decompiled with CFR 0.152.
 */
package org.chorusbdd.chorus.spring;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.chorusbdd.chorus.core.interpreter.SpringInjector;
import org.chorusbdd.chorus.results.FeatureToken;
import org.chorusbdd.chorus.util.logging.ChorusLog;
import org.chorusbdd.chorus.util.logging.ChorusLogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringContextInjector
implements SpringInjector {
    private static ChorusLog log = ChorusLogFactory.getLog(SpringContextInjector.class);
    private Map<Object, ContextWithURL> springContextByCreatingHandler = new HashMap<Object, ContextWithURL>();

    public void injectSpringContext(Object handler, FeatureToken featureToken, String contextFileName) {
        URL url;
        AbstractApplicationContext springContext;
        Class<?> handlerClass = handler.getClass();
        if (featureToken.isConfiguration()) {
            if (contextFileName.endsWith(".xml")) {
                String tmp = String.format("%s-%s.xml", contextFileName.substring(0, contextFileName.length() - 4), featureToken.getConfigurationName());
                URL url2 = handlerClass.getResource(tmp);
                if (url2 != null) {
                    contextFileName = tmp;
                }
            } else {
                log.warn((Object)("Unexpected suffix for Spring config file (should end with .xml) : " + contextFileName));
            }
        }
        if ((springContext = this.getExistingContextByUrl(url = handlerClass.getResource(contextFileName))) == null) {
            springContext = this.createNewContext(handler, contextFileName, handlerClass, url);
        }
        SpringContextInjector.injectResourceFields((ApplicationContext)springContext, handler);
    }

    private AbstractApplicationContext createNewContext(Object handler, String contextFileName, Class handlerClass, URL url) {
        log.debug((Object)("Creating Spring Context from URL " + url));
        ClassPathXmlApplicationContext springContext = new ClassPathXmlApplicationContext(contextFileName, handlerClass);
        this.springContextByCreatingHandler.put(handler, new ContextWithURL((AbstractApplicationContext)springContext, url));
        log.info((Object)("Created new SpringContext for handler " + handlerClass + " at " + contextFileName));
        return springContext;
    }

    private AbstractApplicationContext getExistingContextByUrl(URL url) {
        AbstractApplicationContext result = null;
        for (ContextWithURL c : this.springContextByCreatingHandler.values()) {
            if (!c.url.equals(url)) continue;
            result = c.springContext;
            break;
        }
        return result;
    }

    public static void injectResourceFields(ApplicationContext springContext, Object ... handlers) {
        for (Object handler : handlers) {
            Field[] fields;
            Class<?> handlerClass = handler.getClass();
            for (Field field : fields = handlerClass.getDeclaredFields()) {
                Resource resourceAnnotation = field.getAnnotation(Resource.class);
                if (resourceAnnotation == null) continue;
                boolean beanNameInAnnotation = !"".equals(resourceAnnotation.name());
                String name = beanNameInAnnotation ? resourceAnnotation.name() : field.getName();
                Object bean = springContext.getBean(name);
                log.trace((Object)("Found spring Resource annotation for field " + field + " will attempt to inject Spring bean " + bean));
                if (bean == null) {
                    log.error((Object)("Failed to set @Resource (" + name + "). No such bean exists in application context."));
                }
                try {
                    field.setAccessible(true);
                    field.set(handler, bean);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Failed to set @Resource (" + name + ") with bean of type: " + bean.getClass()), (Throwable)e);
                }
            }
        }
    }

    public void disposeContext(Object handler) {
        ContextWithURL springContext = this.springContextByCreatingHandler.remove(handler);
        if (springContext != null) {
            log.debug((Object)("Destroying spring context " + springContext + " for handler " + handler));
            springContext.springContext.destroy();
        }
    }

    private class ContextWithURL {
        URL url;
        AbstractApplicationContext springContext;

        public ContextWithURL(AbstractApplicationContext springContext, URL url) {
            this.springContext = springContext;
            this.url = url;
        }
    }
}

