/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.ClassDeclarationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.javacutil.TreeUtils;
import org.plumelib.util.StringsPlume;

public class ObjectCreationNode
extends Node {
    protected final NewClassTree tree;
    protected final @Nullable Node enclosingExpression;
    protected final Node constructor;
    protected final List<Node> arguments;
    protected final @Nullable ClassDeclarationNode classbody;

    public ObjectCreationNode(NewClassTree tree, @Nullable Node enclosingExpr, Node constructor, List<Node> arguments, @Nullable ClassDeclarationNode classbody) {
        super(TreeUtils.typeOf((Tree)tree));
        this.tree = tree;
        this.enclosingExpression = enclosingExpr;
        this.constructor = constructor;
        this.arguments = arguments;
        this.classbody = classbody;
    }

    @Pure
    public Node getConstructor() {
        return this.constructor;
    }

    @Pure
    public List<Node> getArguments() {
        return this.arguments;
    }

    @Pure
    public Node getArgument(int i) {
        return this.arguments.get(i);
    }

    @Pure
    public @Nullable Node getEnclosingExpression() {
        return this.enclosingExpression;
    }

    @Pure
    public @Nullable Node getClassBody() {
        return this.classbody;
    }

    @Override
    @Pure
    public NewClassTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitObjectCreation(this, p);
    }

    @SideEffectFree
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.enclosingExpression != null) {
            sb.append(this.enclosingExpression + ".");
        }
        sb.append("new " + this.constructor + "(");
        sb.append(StringsPlume.join((CharSequence)", ", this.arguments));
        sb.append(")");
        if (this.classbody != null) {
            sb.append(" ");
            sb.append(this.classbody.toString());
        }
        return sb.toString();
    }

    @Pure
    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ObjectCreationNode)) {
            return false;
        }
        ObjectCreationNode other = (ObjectCreationNode)obj;
        if (this.constructor == null && other.getConstructor() != null) {
            return false;
        }
        return this.getConstructor().equals(other.getConstructor()) && this.getArguments().equals(other.getArguments()) && (this.getEnclosingExpression() == null ? null == other.getEnclosingExpression() : this.getEnclosingExpression().equals(other.getEnclosingExpression()));
    }

    @SideEffectFree
    public int hashCode() {
        return Objects.hash(this.enclosingExpression, this.constructor, this.arguments);
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(2 + this.arguments.size());
        if (this.enclosingExpression != null) {
            list.add(this.enclosingExpression);
        }
        list.add(this.constructor);
        list.addAll(this.arguments);
        return list;
    }
}

