/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.CaseTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.plumelib.util.StringsPlume;

public class CaseNode
extends Node {
    protected final CaseTree tree;
    protected final AssignmentNode selectorExprAssignment;
    protected final List<Node> caseExprs;
    protected final @Nullable Node guard;

    public CaseNode(CaseTree tree, AssignmentNode selectorExprAssignment, List<Node> caseExprs, @Nullable Node guard, Types types) {
        super(types.getNoType(TypeKind.NONE));
        this.tree = tree;
        this.selectorExprAssignment = selectorExprAssignment;
        this.caseExprs = caseExprs;
        this.guard = guard;
    }

    public AssignmentNode getSwitchOperand() {
        return this.selectorExprAssignment;
    }

    public List<Node> getCaseOperands() {
        return this.caseExprs;
    }

    public @Nullable Node getGuard() {
        return this.guard;
    }

    @Override
    public CaseTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitCase(this, p);
    }

    public String toString() {
        return "case " + StringsPlume.join((CharSequence)", ", this.getCaseOperands()) + ":";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof CaseNode)) {
            return false;
        }
        CaseNode other = (CaseNode)obj;
        return this.getSwitchOperand().equals(other.getSwitchOperand()) && this.getCaseOperands().equals(other.getCaseOperands());
    }

    public int hashCode() {
        return Objects.hash(this.getSwitchOperand(), this.getCaseOperands());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        List<Node> caseOperands = this.getCaseOperands();
        ArrayList<Node> operands = new ArrayList<Node>(caseOperands.size() + 1);
        operands.add(this.getSwitchOperand());
        operands.addAll(caseOperands);
        return operands;
    }
}

