/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.builder;

import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.cfg.builder.ExtendedNode;
import org.checkerframework.dataflow.cfg.builder.Label;
import org.checkerframework.dataflow.cfg.node.Node;

class NodeWithExceptionsHolder
extends ExtendedNode {
    protected final Node node;
    protected final Map<TypeMirror, Set<Label>> exceptions;

    public NodeWithExceptionsHolder(Node node, Map<TypeMirror, Set<Label>> exceptions) {
        super(ExtendedNode.ExtendedNodeType.EXCEPTION_NODE);
        this.node = node;
        this.exceptions = exceptions;
    }

    public Map<TypeMirror, Set<Label>> getExceptions() {
        return this.exceptions;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String toString() {
        return "NodeWithExceptionsHolder(" + this.node + ")";
    }

    @Override
    public String toStringDebug() {
        StringJoiner sj = new StringJoiner(String.format("%n    ", new Object[0]));
        sj.add("NodeWithExceptionsHolder(" + this.node.toStringDebug() + ") {");
        for (Map.Entry<TypeMirror, Set<Label>> entry : this.exceptions.entrySet()) {
            sj.add(entry.getKey() + " => " + entry.getValue());
        }
        sj.add("}");
        return sj.toString();
    }
}

