/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.visualize;

import java.io.File;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CFGVisualizeOptions {
    private static final String DEFAULT_METHOD = "test";
    private static final String DEFAULT_CLASS = "Test";
    private static final String DEFAULT_OUTPUT_DIR = ".";
    private final String input;
    private final String output;
    private final String method;
    private final String clas;
    private final boolean pdf;
    private final boolean verbose;
    private final boolean string;

    private CFGVisualizeOptions(String input, String output, String method, String clas, boolean pdf, boolean verbose, boolean string) {
        this.input = input;
        this.output = output;
        this.method = method;
        this.clas = clas;
        this.pdf = pdf;
        this.verbose = verbose;
        this.string = string;
    }

    public static CFGVisualizeOptions parseArgs(String[] args) {
        String input;
        File file;
        if (args.length == 0) {
            CFGVisualizeOptions.printUsage();
            System.exit(1);
        }
        if (!(file = new File(input = args[0])).canRead()) {
            CFGVisualizeOptions.printError("Cannot read input file: " + file.getAbsolutePath());
            CFGVisualizeOptions.printUsage();
            System.exit(1);
        }
        String method = DEFAULT_METHOD;
        String clas = DEFAULT_CLASS;
        String output = DEFAULT_OUTPUT_DIR;
        boolean pdf = false;
        boolean error = false;
        boolean verbose = false;
        boolean string = false;
        block16: for (int i = 1; i < args.length; ++i) {
            switch (args[i]) {
                case "--outputdir": {
                    if (i >= args.length - 1) {
                        CFGVisualizeOptions.printError("Did not find <outputdir> after --outputdir.");
                        continue block16;
                    }
                    output = args[++i];
                    continue block16;
                }
                case "--pdf": {
                    pdf = true;
                    continue block16;
                }
                case "--method": {
                    if (i >= args.length - 1) {
                        CFGVisualizeOptions.printError("Did not find <name> after --method.");
                        continue block16;
                    }
                    method = args[++i];
                    continue block16;
                }
                case "--class": {
                    if (i >= args.length - 1) {
                        CFGVisualizeOptions.printError("Did not find <name> after --class.");
                        continue block16;
                    }
                    clas = args[++i];
                    continue block16;
                }
                case "--verbose": {
                    verbose = true;
                    continue block16;
                }
                case "--string": {
                    string = true;
                    continue block16;
                }
                default: {
                    CFGVisualizeOptions.printError("Unknown command line argument: " + args[i]);
                    error = true;
                }
            }
        }
        if (error) {
            System.exit(1);
        }
        return new CFGVisualizeOptions(input, output, method, clas, pdf, verbose, string);
    }

    public String getInputFile() {
        return this.input;
    }

    public String getOutputDirectory() {
        return this.output;
    }

    public String getMethodName() {
        return this.method;
    }

    public String getClassName() {
        return this.clas;
    }

    public boolean isPDF() {
        return this.pdf;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isString() {
        return this.string;
    }

    private static void printUsage() {
        System.out.println("Generate the control flow graph of a Java method, represented as a DOT or String graph.");
        System.out.println("Parameters: <inputfile> [--outputdir <outputdir>] [--method <name>] [--class <name>] [--pdf] [--verbose] [--string]");
        System.out.println("  --outputdir: The output directory for the generated files (defaults to '.').");
        System.out.println("  --method:  The method to generate the CFG for (defaults to 'test').");
        System.out.println("  --class:   The class in which to find the method (defaults to 'Test').");
        System.out.println("  --pdf:     Also generate the PDF by invoking 'dot'.");
        System.out.println("  --verbose:   Show the verbose output (defaults to 'false').");
        System.out.println("  --string:  Print the string representation of the control flow graph (defaults to 'false').");
    }

    private static void printError(@Nullable String string) {
        System.err.println("ERROR: " + string);
    }
}

