/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.webapp.impl.security.auth;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.camunda.bpm.webapp.impl.security.auth.Authentication;

public class Authentications
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static String CAM_AUTH_SESSION_KEY = "authenticatedUser";
    private static ThreadLocal<Authentications> currentAuthentications = new ThreadLocal();
    protected Map<String, Authentication> authentications = new HashMap<String, Authentication>();

    public Authentication getAuthenticationForProcessEngine(String engineName) {
        return this.authentications.get(engineName);
    }

    public void addAuthentication(Authentication authentication) {
        this.authentications.put(authentication.getProcessEngineName(), authentication);
    }

    public void removeAuthenticationForProcessEngine(String engineName) {
        this.authentications.remove(engineName);
    }

    public List<Authentication> getAuthentications() {
        return new ArrayList<Authentication>(this.authentications.values());
    }

    public boolean hasAuthenticationForProcessEngine(String engineName) {
        return this.getAuthenticationForProcessEngine(engineName) != null;
    }

    public static void setCurrent(Authentications auth) {
        currentAuthentications.set(auth);
    }

    public static void clearCurrent() {
        currentAuthentications.remove();
    }

    public static Authentications getCurrent() {
        return currentAuthentications.get();
    }

    public static Authentications getFromSession(HttpSession session) {
        Authentications authentications = (Authentications)session.getAttribute(CAM_AUTH_SESSION_KEY);
        if (authentications == null) {
            authentications = new Authentications();
            session.setAttribute(CAM_AUTH_SESSION_KEY, (Object)authentications);
        }
        return authentications;
    }

    public static void revalidateSession(HttpServletRequest request, Authentication authentication) {
        HttpSession session = request.getSession();
        Authentications authentications = Authentications.getFromSession(session);
        session.invalidate();
        session = request.getSession(true);
        if (authentication != null) {
            authentications.addAuthentication(authentication);
            session.setAttribute(CAM_AUTH_SESSION_KEY, (Object)authentications);
        }
    }

    public static void updateSession(HttpSession session, Authentications authentications) {
        if (session != null) {
            session.setAttribute(CAM_AUTH_SESSION_KEY, (Object)authentications);
        }
    }
}

