/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.event;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.spring.boot.starter.event.ExecutionEvent;
import org.camunda.bpm.spring.boot.starter.event.TaskEvent;
import org.camunda.bpm.spring.boot.starter.property.EventingProperty;
import org.springframework.context.ApplicationEventPublisher;

public class PublishDelegateParseListener
extends AbstractBpmnParseListener {
    private static final List<String> TASK_EVENTS = Arrays.asList("complete", "assignment", "create", "delete", "update");
    private static final List<String> EXECUTION_EVENTS = Arrays.asList("start", "end");
    private final TaskListener taskListener;
    private final ExecutionListener executionListener;

    public PublishDelegateParseListener(ApplicationEventPublisher publisher, EventingProperty property) {
        this.taskListener = property.isTask() != false ? delegateTask -> {
            publisher.publishEvent((Object)delegateTask);
            publisher.publishEvent((Object)new TaskEvent(delegateTask));
        } : null;
        this.executionListener = property.isExecution() ? delegateExecution -> {
            publisher.publishEvent((Object)delegateExecution);
            publisher.publishEvent((Object)new ExecutionEvent(delegateExecution));
        } : null;
    }

    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addTaskListener(this.taskDefinition(activity));
        this.addExecutionListener(activity);
    }

    public void parseBoundaryErrorEventDefinition(Element errorEventDefinition, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
    }

    public void parseBoundaryEvent(Element boundaryEventElement, ScopeImpl scopeElement, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
    }

    public void parseBoundarySignalEventDefinition(Element signalEventDefinition, boolean interrupting, ActivityImpl activity) {
    }

    public void parseBoundaryTimerEventDefinition(Element timerEventDefinition, boolean interrupting, ActivityImpl activity) {
    }

    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseCompensateEventDefinition(Element compensateEventDefinition, ActivityImpl activity) {
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseEventBasedGateway(Element eventBasedGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseIntermediateMessageCatchEventDefinition(Element messageEventDefinition, ActivityImpl activity) {
    }

    public void parseIntermediateSignalCatchEventDefinition(Element signalEventDefinition, ActivityImpl activity) {
    }

    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseIntermediateTimerEventDefinition(Element timerEventDefinition, ActivityImpl activity) {
    }

    public void parseManualTask(Element manualTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseMultiInstanceLoopCharacteristics(Element activityElement, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
    }

    public void parseParallelGateway(Element parallelGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseProcess(Element processElement, ProcessDefinitionEntity processDefinition) {
        if (this.executionListener != null) {
            for (String event : EXECUTION_EVENTS) {
                processDefinition.addListener(event, (DelegateListener)this.executionListener);
            }
        }
    }

    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseSequenceFlow(Element sequenceFlowElement, ScopeImpl scopeElement, TransitionImpl transition) {
        this.addExecutionListener(transition);
    }

    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    public void parseTransaction(Element transactionElement, ScopeImpl scope, ActivityImpl activity) {
        this.addExecutionListener(activity);
    }

    private void addExecutionListener(ActivityImpl activity) {
        if (this.executionListener != null) {
            for (String event : EXECUTION_EVENTS) {
                activity.addListener(event, (DelegateListener)this.executionListener);
            }
        }
    }

    private void addExecutionListener(TransitionImpl transition) {
        if (this.executionListener != null) {
            transition.addListener("take", (DelegateListener)this.executionListener);
        }
    }

    private void addTaskListener(TaskDefinition taskDefinition) {
        if (this.taskListener != null) {
            for (String event : TASK_EVENTS) {
                taskDefinition.addTaskListener(event, this.taskListener);
            }
        }
    }

    private TaskDefinition taskDefinition(ActivityImpl activity) {
        UserTaskActivityBehavior activityBehavior = (UserTaskActivityBehavior)activity.getActivityBehavior();
        return activityBehavior.getTaskDefinition();
    }
}

