/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.agent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.bsc.langgraph4j.serializer.StateSerializer;
import org.bsc.langgraph4j.spring.ai.agent.DefaultChatService;
import org.bsc.langgraph4j.spring.ai.agent.ReactAgent;
import org.bsc.langgraph4j.state.Channel;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.support.ToolCallbacks;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;

public abstract class ReactAgentBuilder<B extends ReactAgentBuilder<B, State>, State extends MessagesState<Message>> {
    protected StateSerializer<State> stateSerializer;
    protected ChatModel chatModel;
    protected String systemMessage;
    protected boolean streaming = false;
    protected final List<ToolCallback> tools = new ArrayList<ToolCallback>();
    protected Map<String, Channel<?>> schema;

    public Optional<String> systemMessage() {
        return Optional.ofNullable(this.systemMessage);
    }

    public List<ToolCallback> tools() {
        return this.tools;
    }

    protected B result() {
        return (B)this;
    }

    public B schema(Map<String, Channel<?>> schema) {
        this.schema = schema;
        return this.result();
    }

    public B stateSerializer(StateSerializer<State> stateSerializer) {
        this.stateSerializer = stateSerializer;
        return this.result();
    }

    public B chatModel(ChatModel chatModel, boolean streaming) {
        this.chatModel = chatModel;
        this.streaming = streaming;
        return this.result();
    }

    public B chatModel(ChatModel chatModel) {
        return this.chatModel(chatModel, false);
    }

    public B defaultSystem(String systemMessage) {
        this.systemMessage = systemMessage;
        return this.result();
    }

    public B tool(ToolCallback tool) {
        this.tools.add(Objects.requireNonNull(tool, "tool cannot be null!"));
        return this.result();
    }

    public B tools(List<ToolCallback> tools) {
        this.tools.addAll((Collection<ToolCallback>)Objects.requireNonNull(tools, "tools cannot be null!"));
        return this.result();
    }

    public B tools(ToolCallbackProvider toolCallbackProvider) {
        Objects.requireNonNull(toolCallbackProvider, "toolCallbackProvider cannot be null!");
        ToolCallback[] toolCallbacks = toolCallbackProvider.getToolCallbacks();
        if (toolCallbacks.length == 0) {
            throw new IllegalArgumentException("toolCallbackProvider.getToolCallbacks() cannot be empty!");
        }
        this.tools.addAll(List.of(toolCallbacks));
        return this.result();
    }

    public B toolsFromObject(Object objectWithTools) {
        ToolCallback[] tools = ToolCallbacks.from((Object[])new Object[]{Objects.requireNonNull(objectWithTools, "objectWithTools cannot be null")});
        this.tools.addAll(List.of(tools));
        return this.result();
    }

    public abstract StateGraph<State> build(Function<ReactAgentBuilder<?, ?>, ReactAgent.ChatService> var1) throws GraphStateException;

    public final StateGraph<State> build() throws GraphStateException {
        return this.build(DefaultChatService::new);
    }
}

