/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.agentexecutor;

import java.util.List;
import java.util.Map;
import org.bsc.async.AsyncGenerator;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.action.AsyncNodeActionWithConfig;
import org.bsc.langgraph4j.action.NodeActionWithConfig;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.bsc.langgraph4j.spring.ai.agentexecutor.AgentExecutor;
import org.bsc.langgraph4j.spring.ai.generators.StreamingChatGenerator;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatResponse;
import reactor.core.publisher.Flux;

class CallModel<State extends MessagesState<Message>>
implements NodeActionWithConfig<State> {
    private final AgentExecutor.ChatService chatService;
    private final boolean streaming;

    public static <State extends MessagesState<Message>> AsyncNodeActionWithConfig<State> of(AgentExecutor.ChatService chatService, boolean streaming) {
        return AsyncNodeActionWithConfig.node_async(new CallModel<State>(chatService, streaming));
    }

    protected CallModel(AgentExecutor.ChatService chatService, boolean streaming) {
        this.chatService = chatService;
        this.streaming = streaming;
    }

    public Map<String, Object> apply(State state, RunnableConfig config) throws Exception {
        List messages = state.messages();
        if (messages.isEmpty()) {
            throw new IllegalArgumentException("no input provided!");
        }
        if (this.streaming) {
            Flux<ChatResponse> flux = this.chatService.streamingExecute(messages);
            AsyncGenerator generator = StreamingChatGenerator.builder().startingNode("agent").startingState(state).mapResult(response -> Map.of("messages", response.getResult().getOutput())).build(flux);
            return Map.of("messages", generator);
        }
        ChatResponse response2 = this.chatService.execute(messages);
        AssistantMessage output = response2.getResult().getOutput();
        return Map.of("messages", output);
    }
}

