/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.agentexecutor;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.bsc.langgraph4j.GraphStateException;
import org.bsc.langgraph4j.RunnableConfig;
import org.bsc.langgraph4j.StateGraph;
import org.bsc.langgraph4j.action.Command;
import org.bsc.langgraph4j.agent.Agent;
import org.bsc.langgraph4j.prebuilt.MessagesState;
import org.bsc.langgraph4j.spring.ai.agentexecutor.AgentExecutorBuilder;
import org.bsc.langgraph4j.spring.ai.agentexecutor.CallModel;
import org.bsc.langgraph4j.spring.ai.serializer.std.SpringAIStateSerializer;
import org.bsc.langgraph4j.spring.ai.tool.SpringAIToolService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatResponse;
import reactor.core.publisher.Flux;

public interface AgentExecutor {
    public static final Logger log = LoggerFactory.getLogger(AgentExecutor.class);

    public static Builder builder() {
        return new Builder();
    }

    private static CompletableFuture<Map<String, Object>> executeTools(State state, SpringAIToolService toolService) {
        log.trace("executeTools");
        CompletableFuture<Map<String, Object>> futureResult = new CompletableFuture<Map<String, Object>>();
        Optional message = state.lastMessage();
        if (message.isEmpty()) {
            futureResult.completeExceptionally(new IllegalArgumentException("no input provided!"));
        } else {
            Object t = message.get();
            if (t instanceof AssistantMessage) {
                AssistantMessage assistantMessage = (AssistantMessage)t;
                if (assistantMessage.hasToolCalls()) {
                    return toolService.executeFunctions(assistantMessage.getToolCalls()).thenApply(result -> Map.of("messages", result));
                }
            } else {
                futureResult.completeExceptionally(new IllegalArgumentException("no AssistantMessage provided!"));
            }
        }
        return futureResult;
    }

    private static CompletableFuture<Command> shouldContinue(State state, RunnableConfig config) {
        AssistantMessage assistantMessage;
        Message message = (Message)state.lastMessage().orElseThrow();
        String finishReason = message.getMetadata().getOrDefault("finishReason", "");
        if (message instanceof AssistantMessage && (assistantMessage = (AssistantMessage)message).hasToolCalls()) {
            return CompletableFuture.completedFuture(new Command("continue"));
        }
        if (Objects.equals(Objects.toString(finishReason), "STOP")) {
            return CompletableFuture.completedFuture(new Command("end"));
        }
        return CompletableFuture.completedFuture(new Command("end"));
    }

    public static class Builder
    extends AgentExecutorBuilder<Builder, State> {
        @Override
        public StateGraph<State> build(Function<AgentExecutorBuilder<?, ?>, ChatService> chatServiceFactory) throws GraphStateException {
            if (this.stateSerializer == null) {
                this.stateSerializer = new SpringAIStateSerializer(State::new);
            }
            ChatService chatService = Objects.requireNonNull(chatServiceFactory, "chatServiceFactory cannot be null!").apply(this);
            SpringAIToolService toolService = new SpringAIToolService(this.tools());
            return Agent.builder().stateSerializer(this.stateSerializer).schema(State.SCHEMA).callModelAction(CallModel.of(chatService, this.streaming)).executeToolsAction((state, config) -> AgentExecutor.executeTools(state, toolService)).shouldContinueEdge(AgentExecutor::shouldContinue).build();
        }
    }

    public static class State
    extends MessagesState<Message> {
        public State(Map<String, Object> initData) {
            super(initData);
        }
    }

    public static interface ChatService {
        public ChatClient chatClient();

        default public ChatResponse execute(List<Message> messages) {
            return this.chatClient().prompt().messages(messages).call().chatResponse();
        }

        default public Flux<ChatResponse> streamingExecute(List<Message> messages) {
            return this.chatClient().prompt().messages(messages).stream().chatResponse();
        }
    }
}

