/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.spring.ai.util;

import java.util.Optional;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;

public class MessageUtil {
    public static boolean isToolResponseMessage(Message message) {
        return Optional.ofNullable(message).map(m -> m.getMessageType().equals((Object)MessageType.TOOL)).orElse(false);
    }

    public static Optional<ToolResponseMessage> asToolResponseMessage(Message message) {
        if (message instanceof ToolResponseMessage) {
            ToolResponseMessage result = (ToolResponseMessage)message;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static boolean isAssistantMessage(Message message) {
        return Optional.ofNullable(message).map(m -> m.getMessageType().equals((Object)MessageType.ASSISTANT)).orElse(false);
    }

    public static Optional<AssistantMessage> asAssistantMessage(Message message) {
        if (message instanceof AssistantMessage) {
            AssistantMessage result = (AssistantMessage)message;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static boolean isSystemMessage(Message message) {
        return Optional.ofNullable(message).map(m -> m.getMessageType().equals((Object)MessageType.SYSTEM)).orElse(false);
    }

    public static Optional<SystemMessage> asSystemMessage(Message message) {
        if (message instanceof SystemMessage) {
            SystemMessage result = (SystemMessage)message;
            return Optional.of(result);
        }
        return Optional.empty();
    }

    public static boolean isUserMessage(Message message) {
        return Optional.ofNullable(message).map(m -> m.getMessageType().equals((Object)MessageType.USER)).orElse(false);
    }

    public static Optional<UserMessage> asUserMessage(Message message) {
        if (message instanceof UserMessage) {
            UserMessage result = (UserMessage)message;
            return Optional.of(result);
        }
        return Optional.empty();
    }
}

